/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.service.CodeServiceImpl;
import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_dict_type;
import com.walker.cache.tree.AbstractCacheTreeProvider;
import com.walker.cache.tree.CacheTreeNode;
import com.walker.cache.tree.DefaultCacheTreeNode;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DictCacheProvider
extends AbstractCacheTreeProvider<S_dict_data> {
    private final SortComparator sort = new SortComparator();
    private final NodeComparator nodeSort = new NodeComparator();
    private final Map<String, String> dictTypeIdMap = new HashMap<String, String>();
    private CodeServiceImpl codeService;

    public String getDictTypeId(String dictType) {
        String id = this.dictTypeIdMap.get(dictType);
        if (id == null) {
            throw new IllegalArgumentException("\u6839\u636e\u5b57\u5178\u7c7b\u578b\uff0c\u672a\u627e\u5230id\uff1a" + dictType);
        }
        return id;
    }

    public List<CacheTreeNode> getCodeList(String[] codeIds) {
        ArrayList<CacheTreeNode> result = new ArrayList<CacheTreeNode>(4);
        if (codeIds != null && codeIds.length > 0) {
            for (String cid : codeIds) {
                result.add(this.get(cid));
            }
        }
        return result;
    }

    public List<CacheTreeNode> getCodeChildrenList(String codeTableName) {
        CacheTreeNode node = this.getOneRootNode(codeTableName);
        if (node == null) {
            throw new IllegalArgumentException("not found node: " + codeTableName);
        }
        Collection list = node.getChildren();
        if (list != null) {
            ArrayList<CacheTreeNode> result = new ArrayList<CacheTreeNode>();
            for (CacheTreeNode n : list) {
                result.add(n);
            }
            Collections.sort(result, this.nodeSort);
            return result;
        }
        return null;
    }

    public List<S_dict_data> getRootChildrenOneLevelList(String codeTableName) {
        CacheTreeNode node = this.getOneRootNode(codeTableName);
        if (node == null) {
            throw new IllegalArgumentException("not found node: " + codeTableName);
        }
        Collection list = node.getChildren();
        if (list != null) {
            ArrayList<S_dict_data> result = new ArrayList<S_dict_data>();
            S_dict_data temp = null;
            for (CacheTreeNode n : list) {
                temp = (S_dict_data)n.getSource();
                result.add(temp);
            }
            Collections.sort(result, this.sort);
            return result;
        }
        return null;
    }

    public List<S_dict_data> getCodeChildrenOneLevelList(String id) {
        CacheTreeNode parent = this.get(id);
        if (parent == null) {
            return null;
        }
        Collection list = parent.getChildren();
        if (list != null) {
            ArrayList<S_dict_data> result = new ArrayList<S_dict_data>();
            for (CacheTreeNode n : list) {
                result.add((S_dict_data)n.getSource());
            }
            return result;
        }
        return null;
    }

    public List<CacheTreeNode> getCodeChildrenTreeList(String id) {
        CacheTreeNode parent = this.get(id);
        if (parent == null) {
            return null;
        }
        Collection list = parent.getChildren();
        if (list != null) {
            ArrayList<CacheTreeNode> result = new ArrayList<CacheTreeNode>();
            for (CacheTreeNode n : list) {
                result.add(n);
            }
            return result;
        }
        return null;
    }

    protected Map<String, CacheTreeNode> loadRootList() {
        List<S_dict_type> rootList = this.codeService.queryRootCodeList();
        if (StringUtils.isEmptyList(rootList)) {
            return null;
        }
        ArrayList<S_dict_data> dictList = new ArrayList<S_dict_data>();
        S_dict_data data = null;
        for (S_dict_type type : rootList) {
            data = new S_dict_data();
            data.setDict_code(type.getDict_id());
            data.setDict_label(type.getDict_name());
            data.setParent_id(Long.valueOf(0L));
            dictList.add(data);
            this.dictTypeIdMap.put(type.getDict_type(), String.valueOf(type.getDict_id()));
        }
        return this.obtainMap(dictList);
    }

    protected Map<String, CacheTreeNode> loadChildList() {
        List<S_dict_data> list = this.codeService.queryAllCodeItemList();
        return this.obtainMap(list);
    }

    protected CacheTreeNode toCacheTreeNode(S_dict_data entity) {
        return new DefaultCacheTreeNode(entity.getDict_code().toString(), entity.getDict_label(), (Object)entity, entity.getParent_id().toString());
    }

    public String getProviderName() {
        return "cache.base.dict";
    }

    public Class<?> getProviderType() {
        return S_dict_data.class;
    }

    private Map<String, CacheTreeNode> obtainMap(List<S_dict_data> list) {
        if (list != null && list.size() > 0) {
            TreeMap<String, CacheTreeNode> map = new TreeMap<String, CacheTreeNode>();
            for (S_dict_data code : list) {
                map.put(code.getDict_code().toString(), this.toCacheTreeNode(code));
            }
            return map;
        }
        return null;
    }

    public void setCodeService(CodeServiceImpl codeService) {
        this.codeService = codeService;
    }

    private class SortComparator
    implements Comparator<S_dict_data> {
        private SortComparator() {
        }

        @Override
        public int compare(S_dict_data o1, S_dict_data o2) {
            return o1.getDict_sort() - o2.getDict_sort();
        }
    }

    private class NodeComparator
    implements Comparator<CacheTreeNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(CacheTreeNode o1, CacheTreeNode o2) {
            S_dict_data n1 = (S_dict_data)o1.getSource();
            S_dict_data n2 = (S_dict_data)o2.getSource();
            return n1.getDict_sort() - n2.getDict_sort();
        }
    }
}

