/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.form.FormDataItem;
import com.iplatform.base.service.ConfigFormServiceImpl;
import com.iplatform.base.util.ConfigFormValidateUtils;
import com.iplatform.model.po.S_config_form;
import com.iplatform.model.vo.ConfigFormItemConfigRegListVo;
import com.iplatform.model.vo.ConfigFormItemVo;
import com.iplatform.model.vo.ConfigFormVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.HashMap;
import java.util.List;

public class FormCacheProvider
extends AbstractCacheProvider<S_config_form> {
    private ConfigFormServiceImpl configFormService;

    public void validateForm(FormData formData) {
        HashMap<String, String> map = new HashMap<String, String>();
        Object formItemValue = null;
        for (FormDataItem formDataItem : formData.getFields()) {
            map.put(formDataItem.getName(), formDataItem.getValue());
        }
        S_config_form form = (S_config_form)this.getCacheData(formData.getId().toString());
        ConfigFormVo systemConfigFormVo = null;
        try {
            systemConfigFormVo = (ConfigFormVo)JsonUtils.jsonStringToObject((String)form.getContent(), ConfigFormVo.class);
        }
        catch (Exception e) {
            logger.error("formData.getId()=" + formData.getId() + ", " + e.getMessage(), (Throwable)e);
            throw new PlatformRuntimeException("\u6a21\u677f\u8868\u5355 \u3010" + form.getName() + "\u3011 \u5185\u5bb9\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5JSON\u683c\u5f0f\uff01", e);
        }
        for (ConfigFormItemVo configFormItemVo : systemConfigFormVo.getFields()) {
            String model = configFormItemVo.get__vModel__();
            if (configFormItemVo.get__config__().getRequired().booleanValue() && ((String)map.get(model)).equals("")) {
                throw new PlatformRuntimeException(configFormItemVo.get__config__().getLabel() + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.checkRule(configFormItemVo.get__config__().getRegList(), (String)map.get(model), configFormItemVo.get__config__().getLabel());
        }
    }

    private void checkRule(List<ConfigFormItemConfigRegListVo> regList, String value, String name) {
        if (regList.size() > 0) {
            for (ConfigFormItemConfigRegListVo systemConfigFormItemConfigRegListVo : regList) {
                if (ConfigFormValidateUtils.regular(value, name, systemConfigFormItemConfigRegListVo.getPattern())) continue;
                throw new PlatformRuntimeException(systemConfigFormItemConfigRegListVo.getMessage());
            }
        }
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.configFormService.selectAll((BasePo)new S_config_form());
        if (!StringUtils.isEmptyList((List)hosts)) {
            for (S_config_form h : hosts) {
                cache.put(String.valueOf(h.getId()), (Object)h);
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.form";
    }

    public Class<?> getProviderType() {
        return S_config_form.class;
    }

    public void setConfigFormService(ConfigFormServiceImpl configFormService) {
        this.configFormService = configFormService;
    }
}

