/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.util.CategoryUtils;
import com.iplatform.base.util.cache.CategorySortComparator;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalCategoryCacheProvider
extends AbstractCacheProvider<S_category>
implements CategoryCacheProvider {
    private final CategorySortComparator sortComparator = new CategorySortComparator();
    private CategoryServiceImpl categoryService;

    @Override
    public List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList, int owner) {
        ArrayList<S_category> allTree = new ArrayList<S_category>();
        S_category tempCategory = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            tempCategory = (S_category)((Cachable)it.next()).getValue();
            if (!CategoryUtils.isCondition(tempCategory, type, status, name, categoryIdList, owner)) continue;
            allTree.add(tempCategory);
        }
        return CategoryUtils.acquireListTree(allTree, this.sortComparator);
    }

    @Override
    public List<CategoryTreeVo> getListTree(Integer type, Integer status, String name, int owner) {
        if (StringUtils.isNotEmpty((String)name)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getTree(type, status, name, null, owner);
    }

    @Override
    public S_category get(int id) {
        return (S_category)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(S_category category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(S_category category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List data = this.categoryService.selectAll((BasePo)new S_category());
        if (!StringUtils.isEmptyList((List)data)) {
            for (S_category d : data) {
                cache.put(String.valueOf(d.getId()), (Object)d);
            }
            return data.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.category";
    }

    public Class<?> getProviderType() {
        return S_category.class;
    }

    public void setCategoryService(CategoryServiceImpl categoryService) {
        this.categoryService = categoryService;
    }
}

