/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.NotifyConstants;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.model.po.SfNotification;
import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationTemplateVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.List;
import java.util.Map;

public class LocalNotificationTemplateCache
extends AbstractCacheProvider<NotificationTemplateVo>
implements NotificationTemplateCache {
    private NotificationServiceImpl notificationService;

    @Override
    public NotificationTemplateVo get(String mark) {
        return (NotificationTemplateVo)this.getCacheData(mark);
    }

    @Override
    public void save(NotificationTemplateVo category) {
        this.putCacheData(category.getName(), category);
    }

    @Override
    public void update(NotificationTemplateVo category) {
        this.updateCacheData(category.getName(), category);
    }

    @Override
    public void remove(String mark) {
        this.removeCacheData(mark);
    }

    protected int loadDataToCache(Cache cache) {
        List notificationList = this.notificationService.selectAll((BasePo)new SfNotification());
        if (!StringUtils.isEmptyList((List)notificationList)) {
            Map<Long, SfTemplateMessage> templateMessageMap = this.notificationService.queryTemplateIdMap();
            if (templateMessageMap.size() == 0) {
                logger.warn("\u63d0\u9192\u6a21\u677f\u672a\u627e\u5230\u4efb\u4f55\u6709\u6548\u6570\u636e");
                return 0;
            }
            for (SfNotification h : notificationList) {
                NotificationTemplateVo vo = new NotificationTemplateVo();
                vo.setName(h.getMark());
                if (h.getIsWechat() == NotifyConstants.SWITCH_OPEN) {
                    vo.setWechat(true);
                    vo.setWechatId((long)h.getWechatId().intValue());
                    vo.setWechatTempId(templateMessageMap.get(h.getWechatId().longValue()).getTempId());
                }
                if (h.getIsRoutine() == NotifyConstants.SWITCH_OPEN) {
                    vo.setRoutine(true);
                    vo.setRoutineId((long)h.getRoutineId().intValue());
                    vo.setRoutineTempId(templateMessageMap.get(h.getRoutineId().longValue()).getTempId());
                }
                if (h.getIsSms() == NotifyConstants.SWITCH_OPEN) {
                    vo.setSms(true);
                    vo.setSmsId((long)h.getSmsId().intValue());
                    vo.setSmsTempId(templateMessageMap.get(h.getSmsId().longValue()).getTempId());
                }
                cache.put(h.getMark(), (Object)vo);
            }
            return notificationList.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.notify.template";
    }

    public Class<?> getProviderType() {
        return NotificationTemplateVo.class;
    }

    public void setNotificationService(NotificationServiceImpl notificationService) {
        this.notificationService = notificationService;
    }
}

