/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.iplatform.model.vo.SystemGroupVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.ArrayList;
import java.util.List;

public class LocalSystemGroupCache
extends AbstractCacheProvider<SystemGroupVo>
implements SystemGroupCache {
    private GroupServiceImpl groupService;

    @Override
    public SystemGroupVo get(int id) {
        return (SystemGroupVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(SystemGroupVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(SystemGroupVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.groupService.selectAll((BasePo)new S_group());
        if (!StringUtils.isEmptyList((List)hosts)) {
            ArrayList<SystemGroupVo> groupVoList = new ArrayList<SystemGroupVo>(hosts.size());
            List<S_group_data> groupDataList = this.groupService.queryAllGroupDataList();
            for (S_group s_group : hosts) {
                groupVoList.add(new SystemGroupVo(s_group));
            }
            if (!StringUtils.isEmptyList(groupDataList)) {
                for (S_group_data s_group_data : groupDataList) {
                    for (SystemGroupVo vo : groupVoList) {
                        if (s_group_data.getGid().intValue() != vo.getId().intValue()) continue;
                        vo.addGroupData(s_group_data);
                    }
                }
            }
            for (SystemGroupVo systemGroupVo : groupVoList) {
                cache.put(String.valueOf(systemGroupVo.getId()), (Object)systemGroupVo);
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.group";
    }

    public Class<?> getProviderType() {
        return SystemGroupVo.class;
    }

    public void setGroupService(GroupServiceImpl groupService) {
        this.groupService = groupService;
    }
}

