/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.util.TokenUtils;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import java.util.HashMap;
import java.util.Map;

public class LocalUserOnlineProvider
extends AbstractCacheProvider<UserPrincipal<?>>
implements UserOnlineProvider {
    private Map<String, Long> captchaKeyExpiredMap = new HashMap<String, Long>();

    public LocalUserOnlineProvider() {
        this.runClearDirtyCacheTask();
    }

    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    public String getProviderName() {
        return "cache.base.user_online";
    }

    public Class<?> getProviderType() {
        return UserPrincipal.class;
    }

    public UserPrincipal<?> getUserPrincipal(String token) {
        UserPrincipal userPrincipal = (UserPrincipal)this.getCacheData(token);
        if (userPrincipal == null) {
            logger.warn("UserOnlineProvider \u7f13\u5b58\u7528\u6237\u4e0d\u5b58\u5728, token = " + token);
        }
        return userPrincipal;
    }

    public boolean cacheUserPrincipal(String token, UserPrincipal<?> userPrincipal) {
        logger.debug("\u5199\u5165\u7528\u6237\u767b\u5f55\u7f13\u5b58: " + token + ", " + userPrincipal.getUserName());
        this.putCacheData(token, userPrincipal, TokenUtils.acquireCacheUserExpiredSeconds(30L));
        return true;
    }

    public boolean updateUserPrincipalTimeStamp(String token) {
        return false;
    }

    public boolean removeUserPrincipal(String token) {
        this.removeCacheData(token);
        this.captchaKeyExpiredMap.remove(token);
        return true;
    }

    public void putCacheData(String key, UserPrincipal<?> userPrincipal, long expiredSeconds) {
        this.putCacheData(key, userPrincipal);
        this.captchaKeyExpiredMap.put(key, expiredSeconds);
    }

    private void runClearDirtyCacheTask() {
        logger.info("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1\uff0c\u5b9a\u671f\u6e05\u7406\u8fc7\u671f\u7684\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff0c\u4f46\u6682\u672a\u5b9e\u73b0\u3002");
    }
}

