/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.service.MenuServiceImpl;
import com.iplatform.base.util.MenuUtils;
import com.iplatform.base.util.menu.MenuOrderNumComparator;
import com.iplatform.base.util.menu.ParentMenuComparator;
import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.model.po.S_menu;
import com.iplatform.model.vo.MetaVo;
import com.iplatform.model.vo.RouterVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MenuCacheProvider
extends AbstractCacheProvider<S_menu> {
    private MenuServiceImpl menuService;

    public void setMenuService(MenuServiceImpl menuService) {
        this.menuService = menuService;
    }

    protected int loadDataToCache(Cache cache) {
        List list = this.menuService.selectAll((BasePo)new S_menu());
        if (!StringUtils.isEmptyList((List)list)) {
            for (S_menu h : list) {
                cache.put(h.getMenu_id(), (Object)h);
            }
            return list.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.menu";
    }

    public Class<?> getProviderType() {
        return S_menu.class;
    }

    public boolean isHasChildren(String menuId) {
        List<S_menu> menuAll = this.getCacheMenuList(true, 0);
        for (S_menu menu : menuAll) {
            if (!menu.getParent_id().equals(menuId)) continue;
            return true;
        }
        return false;
    }

    public List<SystemMenu> getMenuList(List<String> roleIdList, int menuScope) {
        if (StringUtils.isEmptyList(roleIdList)) {
            return this.toSystemMenuList(this.getCacheMenuList(true, menuScope));
        }
        ArrayList<SystemMenu> menuList = new ArrayList<SystemMenu>(32);
        List<String> menuIdList = this.menuService.queryRoleMenuIdList(roleIdList);
        if (StringUtils.isEmptyList(menuIdList)) {
            logger.warn("\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u6743\u9650\uff0cmenuIdList = null, roleIdList = {}", roleIdList);
            return menuList;
        }
        S_menu menu = null;
        for (String menuId : menuIdList) {
            menu = (S_menu)this.getCacheData(menuId);
            if (MenuUtils.menuScopeNotMatch(menuScope, menu)) continue;
            menuList.add(new SystemMenu(menu));
        }
        for (String menuId : menuIdList) {
            if (MenuUtils.containMenu(menuList, menuId)) continue;
            menu = (S_menu)this.getCacheData(menuId);
            menuList.add(new SystemMenu(menu));
        }
        Collections.sort(menuList, new ParentMenuComparator());
        Collections.sort(menuList, new MenuOrderNumComparator());
        return menuList;
    }

    public List<SystemMenu> toSystemMenuList(List<S_menu> srcMenuList) {
        ArrayList<SystemMenu> list = new ArrayList<SystemMenu>(32);
        if (StringUtils.isEmptyList(srcMenuList)) {
            return list;
        }
        for (S_menu menu : srcMenuList) {
            list.add(new SystemMenu(menu));
        }
        return list;
    }

    public List<S_menu> getCacheMenuList(boolean containButton, int menuScope) {
        ArrayList<S_menu> data = new ArrayList<S_menu>();
        S_menu menu = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            menu = (S_menu)((Cachable)it.next()).getValue();
            if (MenuUtils.menuScopeNotMatch(menuScope, menu) || menu.getStatus() == 1) continue;
            if (menu.getMenu_type().equals("F")) {
                if (!containButton) continue;
                data.add(menu);
                continue;
            }
            data.add(menu);
        }
        Collections.sort(data, new ParentMenuComparator());
        Collections.sort(data, new MenuOrderNumComparator());
        return data;
    }

    public List<SystemMenu> getChildPerms(List<SystemMenu> list, String parentId) {
        ArrayList<SystemMenu> returnList = new ArrayList<SystemMenu>();
        for (SystemMenu t : list) {
            if (!t.getParent_id().equals(parentId)) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    private void recursionFn(List<SystemMenu> list, SystemMenu t) {
        List<SystemMenu> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SystemMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SystemMenu> getChildList(List<SystemMenu> list, SystemMenu t) {
        ArrayList<SystemMenu> tlist = new ArrayList<SystemMenu>();
        for (SystemMenu n : list) {
            if (!n.getParent_id().equals(t.getMenu_id())) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SystemMenu> list, SystemMenu t) {
        return this.getChildList(list, t).size() > 0;
    }

    public Set<String> getPermissionSet(List<String> menuIdList, boolean showAll, int menuScope) {
        if (StringUtils.isEmptyList(menuIdList) && !showAll) {
            return new HashSet<String>();
        }
        ArrayList<String> permsList = new ArrayList<String>(64);
        List<S_menu> menuAll = this.getCacheMenuList(true, menuScope);
        if (!StringUtils.isEmptyList(menuAll)) {
            for (S_menu menu : menuAll) {
                if (MenuUtils.menuScopeNotMatch(menuScope, menu) || StringUtils.isEmpty((String)menu.getPerms())) continue;
                if (StringUtils.isEmptyList(menuIdList)) {
                    permsList.add(menu.getPerms());
                    continue;
                }
                if (!menuIdList.contains(menu.getMenu_id())) continue;
                permsList.add(menu.getPerms());
            }
        }
        HashSet<String> permsSet = new HashSet<String>();
        for (String perms : permsList) {
            if (!StringUtils.isNotEmpty((String)perms)) continue;
            permsSet.addAll(Arrays.asList(perms.trim().split(",")));
        }
        return permsSet;
    }

    public List<SystemMenu> getMenuTreeAll(List<String> menuIdList, boolean containButton, int menuScope) {
        return this.getMenuTree(menuIdList, containButton, true, menuScope);
    }

    public List<SystemMenu> getMenuTree(List<String> menuIdList, boolean containButton, boolean showAll, int menuScope) {
        ArrayList<SystemMenu> menuGroupList = new ArrayList<SystemMenu>(32);
        if (StringUtils.isEmptyList(menuIdList) && !showAll) {
            return this.getChildPerms(menuGroupList, "0");
        }
        List<S_menu> menuAll = this.getCacheMenuList(containButton, menuScope);
        if (!StringUtils.isEmptyList(menuAll)) {
            for (S_menu menu : menuAll) {
                if (menuIdList == null) {
                    menuGroupList.add(new SystemMenu(menu));
                    continue;
                }
                if (!menuIdList.contains(menu.getMenu_id())) continue;
                menuGroupList.add(new SystemMenu(menu));
            }
        }
        return this.getChildPerms(menuGroupList, "0");
    }

    @Deprecated
    public List<RouterVo> buildMenus(List<SystemMenu> menus) {
        LinkedList<RouterVo> routers = new LinkedList<RouterVo>();
        for (SystemMenu menu : menus) {
            RouterVo router = new RouterVo();
            router.setHidden("1".equals(menu.getVisible()));
            router.setName(MenuUtils.getRouteName(menu));
            router.setPath(MenuUtils.getRouterPath(menu));
            router.setComponent(MenuUtils.getComponent(menu));
            router.setQuery(menu.getQuery());
            router.setMeta(new MetaVo(menu.getMenu_name(), menu.getIcon(), menu.getIs_cache() == 1, menu.getPath()));
            List<SystemMenu> cMenus = menu.getChildren();
            if (!cMenus.isEmpty() && cMenus.size() > 0 && menu.getMenu_type().equals("M")) {
                router.setAlwaysShow(Boolean.valueOf(true));
                router.setRedirect("noRedirect");
                router.setChildren(this.buildMenus(cMenus));
            } else if (MenuUtils.isMenuFrame(menu)) {
                router.setMeta(null);
                childrenList = new ArrayList<RouterVo>();
                children = new RouterVo();
                children.setPath(menu.getPath());
                children.setComponent(menu.getComponent());
                children.setName(StringUtils.capitalize((String)menu.getPath()));
                children.setMeta(new MetaVo(menu.getMenu_name(), menu.getIcon(), menu.getIs_cache() == 1, menu.getPath()));
                children.setQuery(menu.getQuery());
                childrenList.add(children);
                router.setChildren(childrenList);
            } else if (menu.getParent_id().equals("0") && MenuUtils.isInnerLink(menu)) {
                router.setMeta(new MetaVo(menu.getMenu_name(), menu.getIcon()));
                router.setPath("/");
                childrenList = new ArrayList();
                children = new RouterVo();
                String routerPath = MenuUtils.innerLinkReplaceEach(menu.getPath());
                children.setPath(routerPath);
                children.setComponent("InnerLink");
                children.setName(StringUtils.capitalize((String)routerPath));
                children.setMeta(new MetaVo(menu.getMenu_name(), menu.getIcon(), menu.getPath()));
                childrenList.add(children);
                router.setChildren(childrenList);
            }
            routers.add(router);
        }
        return routers;
    }

    public List<String[]> getAllRoleMenuMap() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<Map<String, Object>> list = this.menuService.queryRolesPermList();
        if (StringUtils.isEmptyList(list)) {
            return result;
        }
        String perms = null;
        String menuId = null;
        S_menu menu = null;
        for (Map<String, Object> map : list) {
            menuId = map.get("menu_id").toString();
            menu = (S_menu)this.getCacheData(menuId);
            if (menu == null) {
                throw new IllegalArgumentException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u83dc\u5355:" + menuId);
            }
            perms = menu.getPerms();
            if (StringUtils.isEmpty((String)perms)) continue;
            result.add(new String[]{map.get("role_id").toString(), MenuUtils.acquireUrlFromPerms(perms)});
        }
        Set<String> merchantPermSet = this.getPermissionSet(null, true, 4);
        if (merchantPermSet != null) {
            for (String onePerms : merchantPermSet) {
                result.add(new String[]{"ROLE_MERCHANT", MenuUtils.acquireUrlFromPerms(onePerms)});
            }
            logger.debug("\u6dfb\u52a0\u5546\u6237\uff08\u9876\u7ea7\u673a\u6784\uff09\u89d2\u8272\u6743\u9650\uff1a{}", (Object)merchantPermSet.size());
        }
        return result;
    }

    public List<String> getAllMenuUrlList() {
        ArrayList<String> urlList = new ArrayList<String>(32);
        S_menu menu = null;
        String perms = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            menu = (S_menu)((Cachable)it.next()).getValue();
            perms = menu.getPerms();
            if (StringUtils.isEmpty((String)perms)) continue;
            urlList.add(MenuUtils.acquireUrlFromPerms(perms));
        }
        return urlList;
    }
}

