/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.model.po.S_host;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.PubService;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public class RedisHostCacheProvider
extends RedisCacheProvider<S_host> {
    private PubService pubService;

    public RedisHostCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public String getProviderName() {
        return "cache.system.host";
    }

    public Class<?> getProviderType() {
        return S_host.class;
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.pubService.selectAll((BasePo)new S_host());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) < (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (S_host h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    public void setPubService(PubService pubService) {
        this.pubService = pubService;
    }
}

