/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.iplatform.model.vo.SystemGroupVo;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.List;

public class RedisSystemGroupCache
extends RedisCacheProvider<SystemGroupVo>
implements SystemGroupCache {
    private GroupServiceImpl groupService;

    public RedisSystemGroupCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public SystemGroupVo get(int id) {
        return (SystemGroupVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(SystemGroupVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(SystemGroupVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.groupService.selectAll((BasePo)new S_group());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                ArrayList<SystemGroupVo> groupVoList = new ArrayList<SystemGroupVo>(hosts.size());
                List<S_group_data> groupDataList = this.groupService.queryAllGroupDataList();
                for (S_group s_group : hosts) {
                    groupVoList.add(new SystemGroupVo(s_group));
                }
                if (!StringUtils.isEmptyList(groupDataList)) {
                    for (S_group_data s_group_data : groupDataList) {
                        for (SystemGroupVo vo : groupVoList) {
                            if (s_group_data.getGid().intValue() != vo.getId().intValue()) continue;
                            vo.addGroupData(s_group_data);
                        }
                    }
                }
                for (SystemGroupVo systemGroupVo : groupVoList) {
                    cache.put(String.valueOf(systemGroupVo.getId()), (Object)systemGroupVo);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.group";
    }

    public Class<?> getProviderType() {
        return SystemGroupVo.class;
    }

    public void setGroupService(GroupServiceImpl groupService) {
        this.groupService = groupService;
    }
}

