/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.util.TokenUtils;
import com.iplatform.base.util.UserUtils;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;

public class RedisUserOnlineProvider
extends RedisCacheProvider<String>
implements UserOnlineProvider {
    public RedisUserOnlineProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public String getProviderName() {
        return "cache.base.user_online";
    }

    public Class<?> getProviderType() {
        return String.class;
    }

    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    public UserPrincipal<?> getUserPrincipal(String token) {
        String userJson = (String)this.getCacheData(token);
        if (StringUtils.isEmpty((String)userJson)) {
            logger.warn("\u7f13\u5b58\u672a\u83b7\u53d6\u767b\u5f55\u4fe1\u606f, token=" + token);
            return null;
        }
        try {
            return UserUtils.toUserPrincipal(userJson);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7f13\u5b58\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u9519\u8bef, token=" + token + ", " + e.getMessage(), e);
        }
    }

    public boolean cacheUserPrincipal(String token, UserPrincipal<?> userPrincipal) {
        logger.debug("redis\u5199\u5165\u767b\u5f55\u7528\u6237\u7f13\u5b58(token=uuid): " + token);
        try {
            String userJson = JsonUtils.objectToJsonString((Object)((Object)((DefaultUserPrincipal)userPrincipal)));
            this.putCacheData(token, userJson, TokenUtils.acquireCacheUserExpiredSeconds(30L));
        }
        catch (Exception e) {
            throw new RuntimeException("\u767b\u5f55\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u9519\u8bef: " + e.getMessage(), e);
        }
        return true;
    }

    public boolean updateUserPrincipalTimeStamp(String token) {
        return false;
    }

    public boolean removeUserPrincipal(String token) {
        this.removeCacheData(token);
        return true;
    }
}

