/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.WechatCacheProvider;
import com.iplatform.base.WechatConstants;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisWechatCache
extends RedisCacheProvider<String>
implements WechatCacheProvider {
    public RedisWechatCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getMiniAccessToken() {
        return (String)this.getCacheData("wechat_mini_accessToken");
    }

    @Override
    public String getJsApiTicket() {
        return (String)this.getCacheData("wechat_js_api_ticket");
    }

    @Override
    public String getPublicAccessToken() {
        return (String)this.getCacheData("wechat_public_accessToken");
    }

    @Override
    public void putPublicAccessToken(String value, long expiredSeconds) {
        this.putCacheData("wechat_public_accessToken", value, expiredSeconds);
    }

    @Override
    public void putJsApiTicket(String value) {
        this.putCacheData("wechat_js_api_ticket", value, WechatConstants.REDIS_PUBLIC_JS_API_TICKET_EXPRESS);
    }

    @Override
    public void putMiniAccessToken(String value, long expiredSeconds) {
        this.putCacheData("wechat_mini_accessToken", value, expiredSeconds);
    }

    @Override
    public void removeMiniAccessToken() {
        this.removeCacheData("wechat_mini_accessToken");
    }

    public String getProviderName() {
        return "cache.base.wechat";
    }

    public Class<?> getProviderType() {
        return String.class;
    }
}

