/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.captcha;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.captcha.AbstractCaptchaProvider;
import com.iplatform.base.captcha.JigsawResult;
import com.iplatform.base.util.RandomUtils;
import com.iplatform.base.util.VerifyImgUtil;
import com.walker.infrastructure.utils.Base64Utils;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import com.walker.web.util.IdUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;

public class BlockPuzzleCaptchaProvider
extends AbstractCaptchaProvider {
    private static final int IMAGE_BG_SIZE = 6;

    public CaptchaResult generateCaptcha(Object param) {
        int n = this.bgRandom.nextInt(6) + 1;
        int m = this.blockRandom.nextInt(6) + 1;
        if (n > 6) {
            n = 6;
        }
        if (m > 6) {
            m = 6;
        }
        try {
            String sourceName = "images/jigsaw/original/" + n + ".png";
            BufferedImage sourceImg = this.loadBufferedImage(sourceName);
            String blockName = "images/jigsaw/slidingBlock/" + m + ".png";
            BufferedImage templateImg = this.loadBufferedImage(blockName);
            if (sourceImg == null || templateImg == null) {
                this.logger.error("\u672a\u52a0\u8f7d\u5230\u62fc\u56fe\u9a8c\u8bc1\u56fe\u7247\u8d44\u6e90:" + sourceName + ", or " + blockName);
                return null;
            }
            return this.pictureTemplatesCut(sourceImg, templateImg, VerifyImgUtil.getBase64(templateImg));
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("\u62fc\u56fe\u9a8c\u8bc1\u751f\u6210\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }

    public CaptchaType getCaptchaType() {
        return CaptchaType.JigsawMobile;
    }

    private JigsawResult pictureTemplatesCut(BufferedImage originalImage, BufferedImage jigsawImage, String jigsawImageBase64) {
        JigsawResult jigsawResult = new JigsawResult();
        try {
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            int jigsawWidth = jigsawImage.getWidth();
            int jigsawHeight = jigsawImage.getHeight();
            jigsawResult = BlockPuzzleCaptchaProvider.generateJigsawPoint(originalWidth, originalHeight, jigsawWidth, jigsawHeight);
            int x = jigsawResult.getX();
            int y = jigsawResult.getY();
            BufferedImage newJigsawImage = new BufferedImage(jigsawWidth, jigsawHeight, jigsawImage.getType());
            Graphics2D graphics = newJigsawImage.createGraphics();
            int bold = 5;
            newJigsawImage = graphics.getDeviceConfiguration().createCompatibleImage(jigsawWidth, jigsawHeight, 3);
            BlockPuzzleCaptchaProvider.cutByTemplate(originalImage, jigsawImage, newJigsawImage, x, 0);
            if (captchaInterferenceOptions > 0) {
                String s;
                int position = 0;
                position = originalWidth - x - 5 > jigsawWidth * 2 ? RandomUtils.getRandomInt(x + jigsawWidth + 5, originalWidth - jigsawWidth).intValue() : RandomUtils.getRandomInt(100, x - jigsawWidth - 5).intValue();
                while (jigsawImageBase64.equals(s = this.getSlidingBlock())) {
                }
                BlockPuzzleCaptchaProvider.interferenceByTemplate(originalImage, Objects.requireNonNull(VerifyImgUtil.getBase64StrToImage(s)), position, 0);
            }
            if (captchaInterferenceOptions > 1) {
                String s;
                while (jigsawImageBase64.equals(s = this.getSlidingBlock())) {
                }
                Integer randomInt = RandomUtils.getRandomInt(jigsawWidth, 100 - jigsawWidth);
                BlockPuzzleCaptchaProvider.interferenceByTemplate(originalImage, Objects.requireNonNull(VerifyImgUtil.getBase64StrToImage(s)), randomInt, 0);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(bold, 0, 2));
            graphics.drawImage((Image)newJigsawImage, 0, 0, null);
            graphics.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)newJigsawImage, "png", os);
            byte[] jigsawImages = os.toByteArray();
            ByteArrayOutputStream oriImagesOs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalImage, "jpg", oriImagesOs);
            byte[] oriCopyImages = oriImagesOs.toByteArray();
            jigsawResult.setImageSourceBase64(Base64Utils.encode((byte[])oriCopyImages));
            jigsawResult.setImageBlockBase64(Base64Utils.encode((byte[])jigsawImages));
            jigsawResult.setUuid(IdUtils.simpleUUID());
            this.logger.debug("token\uff1a{},point:{}", new Object[]{jigsawResult.getUuid(), jigsawResult.getX(), jigsawResult.getY()});
            return jigsawResult;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u9a8c\u8bc1\u62fc\u56fe\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getSlidingBlock() throws Exception {
        Integer randomInt = RandomUtils.getRandomInt(0, 6);
        String blockName = "images/jigsaw/slidingBlock/" + randomInt + ".png";
        BufferedImage image = this.loadBufferedImage(blockName);
        if (image == null) {
            image = this.loadBufferedImage("images/jigsaw/slidingBlock/1.png");
        }
        return VerifyImgUtil.getBase64(image);
    }

    private static JigsawResult generateJigsawPoint(int originalWidth, int originalHeight, int jigsawWidth, int jigsawHeight) {
        Random random = new Random();
        int widthDifference = originalWidth - jigsawWidth;
        int heightDifference = originalHeight - jigsawHeight;
        int y = 0;
        int x = widthDifference <= 0 ? 5 : random.nextInt(originalWidth - jigsawWidth - 100) + 100;
        y = heightDifference <= 0 ? 5 : random.nextInt(originalHeight - jigsawHeight) + 5;
        JigsawResult jigsawResult = new JigsawResult();
        jigsawResult.setX(x);
        jigsawResult.setY(y);
        return jigsawResult;
    }

    private static void cutByTemplate(BufferedImage oriImage, BufferedImage templateImage, BufferedImage newImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    newImage.setRGB(i, j, oriImage.getRGB(x + i, y + j));
                    BlockPuzzleCaptchaProvider.readPixel(oriImage, x + i, y + j, values);
                    BlockPuzzleCaptchaProvider.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, BlockPuzzleCaptchaProvider.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                if (!(rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0) && (rgb >= 0 || downRgb < 0)) continue;
                newImage.setRGB(i, j, Color.white.getRGB());
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }

    private static void readPixel(BufferedImage img, int x, int y, int[] pixels) {
        int xStart = x - 1;
        int yStart = y - 1;
        int current = 0;
        for (int i = xStart; i < 3 + xStart; ++i) {
            for (int j = yStart; j < 3 + yStart; ++j) {
                int tx = i;
                if (tx < 0) {
                    tx = -tx;
                } else if (tx >= img.getWidth()) {
                    tx = x;
                }
                int ty = j;
                if (ty < 0) {
                    ty = -ty;
                } else if (ty >= img.getHeight()) {
                    ty = y;
                }
                pixels[current++] = img.getRGB(tx, ty);
            }
        }
    }

    private static void fillMatrix(int[][] matrix, int[] values) {
        int filled = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[] x = matrix[i];
            for (int j = 0; j < x.length; ++j) {
                x[j] = values[filled++];
            }
        }
    }

    private static int avgMatrix(int[][] matrix) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[] x = matrix[i];
            for (int j = 0; j < x.length; ++j) {
                if (j == 1) continue;
                Color c = new Color(x[j]);
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
            }
        }
        return new Color(r / 8, g / 8, b / 8).getRGB();
    }

    private static void interferenceByTemplate(BufferedImage oriImage, BufferedImage templateImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    BlockPuzzleCaptchaProvider.readPixel(oriImage, x + i, y + j, values);
                    BlockPuzzleCaptchaProvider.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, BlockPuzzleCaptchaProvider.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                if (!(rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0) && (rgb >= 0 || downRgb < 0)) continue;
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }
}

