/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.captcha;

import com.iplatform.base.captcha.AbstractCaptchaProvider;
import com.iplatform.base.captcha.JigsawResult;
import com.iplatform.base.util.VerifyImgUtil;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import java.awt.image.BufferedImage;
import java.util.Map;

public class JigsawCaptchaProvider
extends AbstractCaptchaProvider {
    private static final int IMAGE_BG_SIZE = 10;
    private static final int IMAGE_BLOCK_SIZE = 21;

    public CaptchaResult generateCaptcha(Object param) {
        int n = this.bgRandom.nextInt(10) + 1;
        int m = this.blockRandom.nextInt(21) + 1;
        try {
            String sourceName = "images/jigsaw_bg/" + n + ".jpg";
            BufferedImage sourceImg = this.loadBufferedImage(sourceName);
            String blockName = "images/jigsaw_block/" + m + ".png";
            BufferedImage templateImg = this.loadBufferedImage(blockName);
            if (sourceImg == null || templateImg == null) {
                this.logger.error("\u672a\u52a0\u8f7d\u5230\u62fc\u56fe\u9a8c\u8bc1\u56fe\u7247\u8d44\u6e90:" + sourceName + ", or " + blockName);
                return null;
            }
            int w = templateImg.getWidth();
            int h = templateImg.getHeight();
            Map<String, Integer> coord = VerifyImgUtil.generateCutoutCoordinates(w, h);
            int x = coord.get("x");
            int y = coord.get("y");
            int[][] templateData = VerifyImgUtil.getTemplateData(templateImg);
            Map<String, BufferedImage> r = VerifyImgUtil.initSlidingBlock(sourceImg, templateData, x, y, w, h);
            JigsawResult jigsawResult = new JigsawResult();
            jigsawResult.setX(x);
            jigsawResult.setY(y);
            jigsawResult.setImageSourceBase64(VerifyImgUtil.getBase64(r.get("newSourceImg")));
            jigsawResult.setImageBlockBase64(VerifyImgUtil.getBase64(r.get("newTemplateImg")));
            return jigsawResult;
        }
        catch (Exception ex) {
            this.logger.error("\u5904\u7406\u62fc\u56fe\u9a8c\u8bc1\u56fe\u50cf\u9519\u8bef, blockName={}", (Throwable)ex);
            return null;
        }
    }

    public CaptchaType getCaptchaType() {
        return CaptchaType.Jigsaw;
    }
}

