/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.config.PushProperties;
import com.iplatform.base.push.DefaultMailPush;
import com.walker.push.PushManager;
import com.walker.push.Pushable;
import com.walker.push.mail.MailPush;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MailPush.class})
public class PushMailConfig {
    @Bean
    public Pushable mailPush(PushManager pushManager, PushProperties pushProperties, UserCacheProvider userCacheProvider) {
        DefaultMailPush mailPush = new DefaultMailPush();
        mailPush.setMailServerHost(pushProperties.getMailServer());
        mailPush.setMailServerPort("25");
        mailPush.setFromAddress(pushProperties.getMailFrom());
        mailPush.setFromPassword(pushProperties.getMailPassword());
        mailPush.setUserCacheProvider(userCacheProvider);
        mailPush.startup();
        pushManager.register((Pushable)mailPush);
        return mailPush;
    }
}

