/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.config.FileProperties;
import com.iplatform.core.PlatformConfiguration;
import com.walker.infrastructure.utils.ClassUtils;
import java.lang.reflect.Constructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpiConfig
extends PlatformConfiguration {
    private final String DEFAULT_SECURITY_SPI_CLASS = "com.iplatform.security.DefaultSecuritySpi";
    private final String NOTHING_SECURITY_SPI_CLASS = "com.iplatform.base.support.NothingSecuritySpi";
    private final String DEFAULT_FILE_OPERATE_SPI_CLASS = "com.iplatform.file.DefaultFileOperateSpi";

    @Bean
    public FileProperties fileProperties() {
        return new FileProperties();
    }

    @Bean
    public FileOperateSpi fileOperateSpi() {
        try {
            FileOperateSpi fileOperateSpi = this.acquireFileOperateSpi("com.iplatform.file.DefaultFileOperateSpi");
            this.logger.info("\u521b\u5efa 'FileOperateSpi' \u5b9e\u73b0\u5bf9\u8c61\u6210\u529f: com.iplatform.file.DefaultFileOperateSpi");
            return fileOperateSpi;
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                this.logger.error("\u521b\u5efa'FileOperateSpi'\u63d0\u4f9b\u8005\u5bf9\u8c61\u9519\u8bef, \u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728: com.iplatform.file.DefaultFileOperateSpi");
            }
            throw new RuntimeException("\u521b\u5efa 'FileOperateSpi' \u5f02\u5e38: com.iplatform.file.DefaultFileOperateSpi", e);
        }
    }

    @Bean
    public SecuritySpi securitySpi() {
        try {
            SecuritySpi securitySpi = this.acquireSecuritySpi("com.iplatform.security.DefaultSecuritySpi");
            this.logger.info("\u521b\u5efa SecuritySpi \u5b9e\u73b0\u5bf9\u8c61\u6210\u529f: com.iplatform.security.DefaultSecuritySpi");
            return securitySpi;
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                this.logger.error("\u521b\u5efa'SecuritySpi'\u63d0\u4f9b\u8005\u5bf9\u8c61\u9519\u8bef, \u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728: com.iplatform.security.DefaultSecuritySpi");
                this.logger.warn("\u521b\u5efa\u5185\u7f6e\u9ed8\u8ba4SPI: com.iplatform.base.support.NothingSecuritySpi");
                try {
                    return this.acquireSecuritySpi("com.iplatform.base.support.NothingSecuritySpi");
                }
                catch (Exception ex) {
                    this.logger.error(".............", (Throwable)ex);
                    throw new RuntimeException("\u521b\u5efa\u5185\u7f6eSPI\u5f02\u5e38: com.iplatform.base.support.NothingSecuritySpi", ex);
                }
            }
            throw new RuntimeException("\u521b\u5efaSPI\u5f02\u5e38:" + e.getMessage(), e);
        }
    }

    private FileOperateSpi acquireFileOperateSpi(String clazzName) throws Exception {
        Class schedulerClass = ClassUtils.forName((String)clazzName, (ClassLoader)SpiConfig.class.getClassLoader());
        Constructor constructor = schedulerClass.getConstructor(new Class[0]);
        FileOperateSpi securitySpi = (FileOperateSpi)constructor.newInstance(new Object[0]);
        return securitySpi;
    }

    private SecuritySpi acquireSecuritySpi(String clazzName) throws Exception {
        Class schedulerClass = ClassUtils.forName((String)clazzName, (ClassLoader)SpiConfig.class.getClassLoader());
        Constructor constructor = schedulerClass.getConstructor(new Class[0]);
        SecuritySpi securitySpi = (SecuritySpi)constructor.newInstance(new Object[0]);
        return securitySpi;
    }
}

