/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.SecuritySpi;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.config.LogProperties;
import com.iplatform.base.config.LoginStrategyProperties;
import com.iplatform.base.config.RestTemplateProperties;
import com.iplatform.base.config.SecurityUserProperties;
import com.iplatform.base.config.TcpProperties;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.base.support.LogAspect;
import com.iplatform.base.support.PlatformOperationInterceptor;
import com.iplatform.base.support.strategy.AbstractLoginStrategy;
import com.iplatform.base.support.strategy.LoginStrategyManager;
import com.iplatform.base.support.strategy.MobileOnceLoginStrategy;
import com.iplatform.base.support.strategy.WebOnceLoginStrategy;
import com.iplatform.core.PlatformConfiguration;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.RestTemplateConfig;
import com.walker.web.RestTemplateFactory;
import com.walker.web.TokenGenerator;
import com.walker.web.WebAgentService;
import com.walker.web.agent.BrowserCapWebAgentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebCommonConfig
extends PlatformConfiguration
implements WebMvcConfigurer {
    private TokenGenerator tokenGenerator;

    @Autowired
    public WebCommonConfig(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    @Bean
    public LoginStrategyProperties loginStrategyProperties() {
        return new LoginStrategyProperties();
    }

    @Bean
    public SecurityUserProperties securityUserProperties() {
        return new SecurityUserProperties();
    }

    @Bean
    public LoginStrategyManager loginStrategyManager(UserLoginCache userLoginCache) {
        LoginStrategyManager manager = new LoginStrategyManager();
        manager.setUserLoginCache(userLoginCache);
        return manager;
    }

    @Bean
    public WebOnceLoginStrategy webOnceLoginStrategy(UserLoginCache userLoginCache, LoginStrategyProperties loginStrategyProperties, LoginStrategyManager loginStrategyManager) {
        List<String> enabledNameList = loginStrategyProperties.getLoginStrategyList();
        WebOnceLoginStrategy strategy = new WebOnceLoginStrategy();
        strategy.setUserLoginCache(userLoginCache);
        strategy.setTokenExpireWeb(loginStrategyProperties.getTokenExpireWeb());
        strategy.setName("PC\u7aef\u540c\u4e00\u8d26\u53f7\u53ea\u80fd\u767b\u5f55\u4e00\u6b21");
        this.setupRegisterLoginStrategy(enabledNameList, strategy, loginStrategyManager, WebOnceLoginStrategy.class.getName());
        return strategy;
    }

    @Bean
    public MobileOnceLoginStrategy mobileOnceLoginStrategy(UserLoginCache userLoginCache, LoginStrategyProperties loginStrategyProperties, LoginStrategyManager loginStrategyManager) {
        List<String> enabledNameList = loginStrategyProperties.getLoginStrategyList();
        MobileOnceLoginStrategy strategy = new MobileOnceLoginStrategy();
        strategy.setUserLoginCache(userLoginCache);
        strategy.setTokenExpireMobile(loginStrategyProperties.getTokenExpireMobile());
        strategy.setName("\u79fb\u52a8\u7aef\u540c\u4e00\u8d26\u53f7\u53ea\u80fd\u767b\u5f55\u4e00\u6b21");
        this.setupRegisterLoginStrategy(enabledNameList, strategy, loginStrategyManager, MobileOnceLoginStrategy.class.getName());
        return strategy;
    }

    private void setupRegisterLoginStrategy(List<String> enabledNameList, AbstractLoginStrategy strategy, LoginStrategyManager loginStrategyManager, String strategyClazz) {
        if (!StringUtils.isEmptyList(enabledNameList)) {
            for (String name : enabledNameList) {
                if (!name.equals(strategyClazz)) continue;
                strategy.setEnabled(true);
                loginStrategyManager.register(strategyClazz, strategy);
                this.logger.info("\u542f\u7528\u4e86\u767b\u5f55\u7b56\u7565\uff1a{}", (Object)strategy.getName());
                break;
            }
        }
    }

    @Bean
    public TcpProperties tcpProperties() {
        return new TcpProperties();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        PlatformOperationInterceptor platformOperationInterceptor = new PlatformOperationInterceptor();
        platformOperationInterceptor.setTokenGenerator(this.tokenGenerator);
        registry.addInterceptor((HandlerInterceptor)platformOperationInterceptor);
        this.logger.info(".......... WebOperationInterceptor \u6ce8\u518c\u6210\u529f");
    }

    @Bean
    public RestTemplateProperties restTemplateProperties() {
        return new RestTemplateProperties();
    }

    @Bean
    public RestTemplate restTemplateOkHttp(RestTemplateProperties restTemplateProperties) {
        RestTemplateConfig config = new RestTemplateConfig();
        config.setKeepAliveDurationSeconds(restTemplateProperties.getKeepAliveDurationSeconds());
        config.setMaxIdleConnections((int)restTemplateProperties.getMaxIdleConnections());
        config.setConnectTimeoutSeconds(restTemplateProperties.getConnectTimeoutSeconds());
        config.setReadTimeoutSeconds(restTemplateProperties.getReadTimeoutSeconds());
        config.setWriteTimeoutSeconds(restTemplateProperties.getWriteTimeoutSeconds());
        RestTemplate restTemplate = RestTemplateFactory.createRestTemplate((RestTemplateFactory.HttpType)RestTemplateFactory.HttpType.OkHttp, (RestTemplateConfig)config);
        return restTemplate;
    }

    @Bean
    public WebAgentService webAgentService() {
        return new BrowserCapWebAgentService();
    }

    @Bean
    public LogProperties logProperties() {
        return new LogProperties();
    }

    @Bean
    public LogAspect logAspect(SecuritySpi securitySpi, LogServiceImpl logService, LogProperties logProperties) {
        LogAspect logAspect = new LogAspect();
        logAspect.setSecuritySpi(securitySpi);
        logAspect.setLogService(logService);
        logAspect.setEnableLog(logProperties.isOperateEnabled());
        this.logger.info("\u521b\u5efa:LogAspect...");
        return logAspect;
    }
}

