/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.base.util.CategoryUtils;
import com.iplatform.base.util.TextUtils;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
extends BaseServiceImpl {
    private static final String SQL_MAX_ID = "select max(id) from s_category";
    private static final String SQL_GET_TREE = "select * from s_category where owner=:owner";

    public void execUpdateCategory(S_category category) {
        this.save((BasePo)category);
        if (category.getStatus() == 0) {
            this.execute("update s_category set status=0 where path like ?", new Object[]{"/" + category.getId() + "/"});
        } else {
            this.updatePidStatusById(category.getId());
        }
    }

    private Boolean updatePidStatusById(Integer id) {
        S_category category = (S_category)this.get((BasePo)new S_category(id));
        if (category == null) {
            return true;
        }
        List<Integer> categoryIdList = TextUtils.stringToArrayByRegex(category.getPath(), "/");
        categoryIdList.removeIf(i -> i.equals(0));
        if (StringUtils.isEmptyList(categoryIdList)) {
            return false;
        }
        HashMap<String, List<Integer>> param = new HashMap<String, List<Integer>>(2);
        param.put("ids", categoryIdList);
        this.execute("update s_category set status=1 where id in (:ids)", param);
        return true;
    }

    public int queryChildCategorySize(int pid) {
        return this.queryForInt("select count(id) from s_category where pid=?", new Object[]{pid});
    }

    public int queryNextId() {
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[0]);
        return maxId + 1;
    }

    public int queryNameUnique(String name, Integer type, Integer owner, int id) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder("select count(id) from s_category where owner=:owner and name=:name");
        param.put("owner", owner);
        param.put("name", name);
        if (type != null) {
            sql.append(" and type=:type");
            param.put("type", type);
        }
        if (id > 0) {
            sql.append(" and id<>:id");
            param.put("id", id);
        }
        return this.queryForInt(sql.toString(), param);
    }

    @Deprecated
    public List<CategoryTreeVo> getListTree(Integer type, Integer status, String name, int owner) {
        if (StringUtils.isNotEmpty((String)name)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getTree(type, status, name, null, owner);
    }

    @Deprecated
    private List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList, int owner) {
        ArrayList<CategoryTreeVo> treeList = new ArrayList<CategoryTreeVo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_GET_TREE);
        parameters.put("owner", owner);
        if (!StringUtils.isEmptyList(categoryIdList)) {
            sql.append(" and id in (:ids)");
            parameters.put("ids", categoryIdList);
        }
        if (type != null) {
            sql.append(" and type = :type");
            parameters.put("type", type);
        }
        if (status != null && status >= 0) {
            sql.append(" and status = :status");
            parameters.put("status", status);
        }
        sql.append(" order by sort desc, id asc");
        List allTree = this.select(sql.toString(), parameters, (BasePo)new S_category());
        if (StringUtils.isEmptyList((List)allTree)) {
            return new ArrayList<CategoryTreeVo>(2);
        }
        for (Object category : allTree) {
            treeList.add(CategoryUtils.toCategoryTreeVo((S_category)category));
        }
        HashMap<Integer, CategoryTreeVo> map = new HashMap<Integer, CategoryTreeVo>(treeList.size());
        for (CategoryTreeVo categoryTreeVo : treeList) {
            map.put(categoryTreeVo.getId(), categoryTreeVo);
        }
        ArrayList<CategoryTreeVo> list = new ArrayList<CategoryTreeVo>();
        CategoryTreeVo parentTree = null;
        for (CategoryTreeVo tree : treeList) {
            parentTree = (CategoryTreeVo)map.get(tree.getPid());
            if (parentTree != null) {
                parentTree.getChild().add(tree);
                continue;
            }
            list.add(tree);
        }
        return list;
    }
}

