/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.model.po.S_dept;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DeptServiceImpl
extends BaseServiceImpl {
    private static final String WHERE_QUERY_ROOT_LIST = "where parent_id=0 order by order_num";
    private static final String WHERE_QUERY_ROOT_LIST_BY_ID = "where parent_id=0 and id=? order by order_num";
    private static final String WHERE_QUERY_ROOT_ONE_CHILDREN = "where org_id=:orgId";
    private static final String QUERY_SUB_SIZE_IN_CURRENT = "select count(id) total from s_dept where parent_id=?";
    private static final String QUERY_USER_SIZE_IN_CURRENT = "select count(id) total from s_user_core where dept_id=?";
    private static final String QUERY_DEPT_FOR_CACHE = "select * from s_dept order by parent_id, order_num";
    private static final String QUERY_TREE_ALL = "select * from s_dept where del_flag=0 and status=0 order by parent_id, order_num";
    private static final String QUERY_TREE_ONE = "select * from s_dept where org_id=? and del_flag=0 and status=0 order by parent_id, order_num";

    public List<S_dept> queryRootOrgList(long orgRootId) {
        if (orgRootId <= 0L) {
            return this.select((BasePo)new S_dept(), WHERE_QUERY_ROOT_LIST, new Object[0]);
        }
        return this.select((BasePo)new S_dept(), WHERE_QUERY_ROOT_LIST_BY_ID, new Object[]{orgRootId});
    }

    public List<S_dept> queryRootOrgChildrenList(long orgRootId, String deptName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("orgId", orgRootId);
        StringBuilder sql = new StringBuilder(WHERE_QUERY_ROOT_ONE_CHILDREN);
        if (StringUtils.isNotEmpty((String)deptName)) {
            sql.append(" and dept_name like :deptName");
            parameters.put("deptName", "%" + deptName + "%");
        }
        sql.append(" order by parent_id, order_num");
        return this.select((BasePo)new S_dept(), sql.toString(), parameters);
    }

    public S_dept queryOneDept(long id) {
        return (S_dept)this.get((BasePo)new S_dept(Long.valueOf(id)));
    }

    public int querySubDeptSizeInCurrent(long id) {
        return (Integer)this.sqlMathQuery(QUERY_SUB_SIZE_IN_CURRENT, new Object[]{id}, Integer.class);
    }

    public long queryUserSizeInCurrent(long id) {
        return (Long)this.sqlMathQuery(QUERY_USER_SIZE_IN_CURRENT, new Object[]{id}, Long.class);
    }

    public List<S_dept> queryAllDeptListForCache() {
        return this.select(QUERY_DEPT_FOR_CACHE, new Object[0], (BasePo)new S_dept());
    }

    public List<S_dept> queryOrgListForTree(long orgId) {
        if (orgId <= 0L) {
            return this.select(QUERY_TREE_ALL, new Object[0], (BasePo)new S_dept());
        }
        return this.select(QUERY_TREE_ONE, new Object[]{orgId}, (BasePo)new S_dept());
    }
}

