/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.model.po.S_menu;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends BaseServiceImpl {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SQL_QUERY_ROLE_MENUS = "select DISTINCT(menu_id) from s_role_menu where role_id in (:roleIdList)";
    private static final String SQL_SAME_MENU_PARENT = "select * from s_menu where parent_id=? and menu_name = ?";
    private static final String SQL_MENU_USER = "select count(menu_id) total from s_role_menu where menu_id=?";

    public int queryRoleMenuSize(String menuId) {
        return (Integer)this.sqlMathQuery(SQL_MENU_USER, new Object[]{menuId}, Integer.class);
    }

    public S_menu queryExistMenuInParent(String parentId, String menuName) {
        List list = this.select(SQL_SAME_MENU_PARENT, new Object[]{parentId, menuName}, (BasePo)new S_menu());
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_menu)list.get(0);
    }

    public List<String> queryRoleMenuIdList(List<String> roleIdList) {
        if (StringUtils.isEmptyList(roleIdList)) {
            return null;
        }
        ArrayList<Long> roleIdValueList = new ArrayList<Long>(4);
        for (String roleId : roleIdList) {
            if (!StringUtils.isNumeric((String)roleId)) continue;
            roleIdValueList.add(Long.parseLong(roleId));
        }
        if (StringUtils.isEmptyList(roleIdValueList)) {
            return null;
        }
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("roleIdList", roleIdValueList);
        List list = this.queryListObjectWhereIn(SQL_QUERY_ROLE_MENUS, (SqlParameterSource)sqlParameterSource);
        this.logger.debug("\u67e5\u8be2\u89d2\u8272\u6743\u9650\u96c6\u5408: {}", (Object)list);
        if (list != null && list.size() > 0) {
            ArrayList<String> menuIdList = new ArrayList<String>(64);
            for (Map map : list) {
                menuIdList.add(map.values().toArray()[0].toString());
            }
            return menuIdList;
        }
        return null;
    }

    public List<Map<String, Object>> queryRolesPermList() {
        return this.select("select * from s_role_menu", new Object[0]);
    }
}

