/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.base.PlatformUserCallback;
import com.iplatform.base.callback.UserProfileCallback;
import com.iplatform.base.pojo.UserInfoRequest;
import com.iplatform.base.util.role.SystemRole;
import com.iplatform.model.po.S_role;
import com.iplatform.model.po.S_user_core;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends BaseServiceImpl {
    public static final String SQL_QUERY_USER_ROLES = "select role_id from s_role_user where user_id = ?";
    public static final String SQL_QUERY_USER_LOGIN_WHERE = "where user_name = ?";
    public static final String SQL_QUERY_USER_PHONE_WHERE = "where phonenumber = ?";
    public static final String SQL_QUERY_USER_EMAIL_WHERE = "where email = ?";
    public static final String SQL_PAGE_ORG_USER = "select * from s_user_core where user_type<99 and org_id=:orgId";
    public static final String SQL_INSERT_ROLE_USER = "insert into s_role_user(user_id, role_id, org_id) values(?,?,0)";
    public static final String SQL_UPDATE_STATUS = "update s_user_core set status=? where id=?";
    public static final String SQL_DELETE_USER_ROLE = "delete from s_role_user where user_id=?";
    public static final String SQL_RESET_PASSWORD = "update s_user_core set password=? where id=?";
    private static final String SQL_USER_DATASCOPE_MENU_LIST = "select DISTINCT(menu_id) from s_role_menu where role_id in (:roleIds) and menu_id like 'data_scope,%'";
    private static final String SQL_ORG_ROLES = "select * from s_role where org_id=? and status=0 and del_flag=0";
    private static final String SQL_USER_ROLE_lIST = "select r.* from s_role_user ru, s_role r where ru.user_id=? and ru.role_id=r.role_id";

    public void execUpdateUserInfo(UserInfoRequest request, long userId, UserProfileCallback callback) {
        S_user_core userCore = new S_user_core(Long.valueOf(userId));
        if (StringUtils.isNotEmpty((String)request.getRealName())) {
            userCore.setNick_name(request.getRealName());
        }
        if (StringUtils.isNotEmpty((String)request.getPassword())) {
            userCore.setPassword(request.getPassword());
            userCore.setModify_pwd(Integer.valueOf(1));
        }
        this.update((BasePo)userCore);
        if (callback != null) {
            callback.onUpdateUser(userCore, request);
        }
    }

    public void execForceChangePassword(long userId, String encryptPassword) {
        S_user_core userCore = new S_user_core(Long.valueOf(userId));
        userCore.setPassword(encryptPassword);
        userCore.setModify_pwd(Integer.valueOf(1));
        this.update((BasePo)userCore);
    }

    public void execResetPassword(long userId, String encryptPassword) {
        this.execute(SQL_RESET_PASSWORD, new Object[]{encryptPassword, userId});
    }

    public void execDeleteUser(long userId, PlatformUserCallback platformUserCallback) {
        this.execute(SQL_DELETE_USER_ROLE, new Object[]{userId});
        this.delete((BasePo)new S_user_core(Long.valueOf(userId)));
        if (platformUserCallback != null) {
            platformUserCallback.onDeleteUser(userId);
        }
    }

    public void execUpdateUserStatus(long userId, int status) {
        this.execute(SQL_UPDATE_STATUS, new Object[]{status, userId});
    }

    public void execSaveUser(S_user_core user_core, Long[] roleIds, PlatformUserCallback platformUserCallback) {
        if (roleIds != null && roleIds.length > 0) {
            Long[] longArray = roleIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long roleId = longArray[i];
                this.execute(SQL_INSERT_ROLE_USER, new Object[]{user_core.getId(), roleId});
            }
        }
        this.insert((BasePo)user_core);
        if (platformUserCallback != null) {
            platformUserCallback.onCreateNewUser(user_core);
        }
    }

    public void execUpdateUser(S_user_core user_core, Long[] roleIds, PlatformUserCallback platformUserCallback) {
        this.execUpdateAuthRole(user_core.getId(), roleIds);
        this.save((BasePo)user_core);
        if (platformUserCallback != null) {
            platformUserCallback.onUpdateUser(user_core);
        }
    }

    public void execUpdateAuthRole(long userId, Long[] roleIds) {
        this.execute(SQL_DELETE_USER_ROLE, new Object[]{userId});
        if (roleIds != null && roleIds.length > 0) {
            Long[] longArray = roleIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long roleId = longArray[i];
                this.execute(SQL_INSERT_ROLE_USER, new Object[]{userId, roleId});
            }
        }
    }

    public S_user_core queryUserByEmail(String email) {
        List list = this.select((BasePo)new S_user_core(), SQL_QUERY_USER_EMAIL_WHERE, new Object[]{email});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_user_core)list.get(0);
    }

    public S_user_core queryUserByPhone(String phoneNumber) {
        List list = this.select((BasePo)new S_user_core(), SQL_QUERY_USER_PHONE_WHERE, new Object[]{phoneNumber});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_user_core)list.get(0);
    }

    public S_user_core queryUserByLoginId(String loginId) {
        List list = this.select((BasePo)new S_user_core(), SQL_QUERY_USER_LOGIN_WHERE, new Object[]{loginId});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_user_core)list.get(0);
    }

    public GenericPager<S_user_core> queryPageUserList(long orgId, long deptId, String loginId, String phoneNumber, int status) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_ORG_USER);
        parameters.put("orgId", orgId);
        if (deptId > 0L) {
            sql.append(" and dept_id = :deptId");
            parameters.put("deptId", deptId);
        }
        if (StringUtils.isNotEmpty((String)loginId)) {
            sql.append(" and user_name = :userName");
            parameters.put("userName", loginId);
        }
        if (StringUtils.isNotEmpty((String)phoneNumber)) {
            sql.append(" and phonenumber like :phoneNumber");
            parameters.put("phoneNumber", "%" + phoneNumber + "%");
        }
        if (status >= 0) {
            sql.append(" and status=:status");
            parameters.put("status", status);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_user_core());
    }

    public Object[] queryLoginUser(String loginId, boolean isPhone) {
        List list = null;
        list = isPhone ? this.select((BasePo)new S_user_core(), SQL_QUERY_USER_PHONE_WHERE, new Object[]{loginId}) : this.select((BasePo)new S_user_core(), SQL_QUERY_USER_LOGIN_WHERE, new Object[]{loginId});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        Object[] userInfo = new Object[2];
        S_user_core userCore = (S_user_core)list.get(0);
        List<String> roleIdList = this.queryUserRoleIdList(userCore.getId());
        userInfo[0] = userCore;
        userInfo[1] = roleIdList;
        return userInfo;
    }

    public S_user_core queryLoginUserOnly(String loginId) {
        List list = this.select((BasePo)new S_user_core(), SQL_QUERY_USER_LOGIN_WHERE, new Object[]{loginId});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_user_core)list.get(0);
    }

    public List<String> queryUserDataScopeMenuIdList(List<String> roleIds) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>(2);
        parameters.put("roleIds", roleIds);
        List list = this.select(SQL_USER_DATASCOPE_MENU_LIST, parameters);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<String> menuIdList = new ArrayList<String>(8);
        for (Map map : list) {
            menuIdList.add(map.get("menu_id").toString());
        }
        return menuIdList;
    }

    public List<String> queryUserRoleIdList(long userId) {
        List list = this.select(SQL_QUERY_USER_ROLES, new Object[]{userId});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<String> roleIdList = new ArrayList<String>(4);
        for (Map m : list) {
            roleIdList.add(m.get("role_id").toString());
        }
        return roleIdList;
    }

    public List<SystemRole> queryAuthRoleList(long orgId, long userId) {
        List orgRoleList = this.select(SQL_ORG_ROLES, new Object[]{orgId}, (BasePo)new S_role());
        if (StringUtils.isEmptyList((List)orgRoleList)) {
            return null;
        }
        ArrayList<SystemRole> systemRoleList = new ArrayList<SystemRole>(8);
        List<String> userRoleIdList = this.queryUserRoleIdList(userId);
        if (!StringUtils.isEmptyList(userRoleIdList)) {
            SystemRole systemRole = null;
            for (S_role role : orgRoleList) {
                systemRole = new SystemRole(role);
                if (userRoleIdList.contains(String.valueOf(role.getRole_id()))) {
                    systemRole.setFlag(true);
                }
                systemRoleList.add(systemRole);
            }
        } else {
            for (S_role role : orgRoleList) {
                systemRoleList.add(new SystemRole(role));
            }
        }
        return systemRoleList;
    }

    @Deprecated
    public List<S_role> queryUserRoleList(long userId) {
        return this.select(SQL_USER_ROLE_lIST, new Object[]{userId}, (BasePo)new S_role());
    }
}

