/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support;

import com.iplatform.base.AsyncManager;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.model.po.S_oper_log;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseCode;
import com.walker.web.log.BusinessType;
import com.walker.web.log.Log;
import com.walker.web.util.IpUtils;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

@Aspect
public class LogAspect {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_DATA_SIZE = 2000;
    private static final int MAX_ERROR_SIZE = 255;
    private SecuritySpi securitySpi;
    private LogServiceImpl logService;
    private boolean enableLog = true;
    private static final String ERROR_LOG = "\u65e5\u5fd7\u5207\u9762\u8bb0\u5f55\u5f02\u5e38:";

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public void setLogService(LogServiceImpl logService) {
        this.logService = logService;
    }

    public void setSecuritySpi(SecuritySpi securitySpi) {
        this.securitySpi = securitySpi;
    }

    @AfterReturning(pointcut="@annotation(logAnnotation)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Log logAnnotation, Object jsonResult) {
        if (this.enableLog) {
            this.handleLog(joinPoint, logAnnotation, null, jsonResult);
        }
    }

    @AfterThrowing(value="@annotation(logAnnotation)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Log logAnnotation, Exception e) {
        if (this.enableLog) {
            this.handleLog(joinPoint, logAnnotation, e, null);
        }
    }

    private void handleLog(JoinPoint joinPoint, Log logAnnotation, Exception e, Object jsonResult) {
        try {
            String res;
            S_oper_log s_oper_log = new S_oper_log();
            S_user_core user_core = this.securitySpi.getCurrentUser();
            if (user_core != null) {
                s_oper_log.setOper_name(user_core.getUser_name());
            }
            if (e == null) {
                s_oper_log.setStatus(ResponseCode.SUCCESS.getCode());
            } else {
                s_oper_log.setStatus(ResponseCode.ERROR.getCode());
                s_oper_log.setError_msg(StringUtils.substring((String)e.getMessage(), (int)0, (int)255));
            }
            String requestMethod = ServletUtils.getRequest().getMethod();
            String ip = IpUtils.getIpAddr((HttpServletRequest)ServletUtils.getRequest());
            s_oper_log.setOper_ip(ip);
            s_oper_log.setOper_url(ServletUtils.getRequest().getRequestURI());
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            s_oper_log.setMethod(className + "." + methodName);
            s_oper_log.setRequest_method(requestMethod);
            s_oper_log.setOper_location("");
            s_oper_log.setTitle(logAnnotation.title());
            s_oper_log.setOperate_user(Integer.valueOf(logAnnotation.operatorType().getIndex()));
            BusinessType businessType = logAnnotation.businessType();
            s_oper_log.setBusiness_type(Integer.valueOf(businessType.getIndex()));
            if (logAnnotation.isSaveRequestData() && businessType.isSaveRequest()) {
                if (requestMethod.equals("POST") || requestMethod.equals("PUT")) {
                    String params = this.argsArrayToString(joinPoint.getArgs());
                    if (StringUtils.isNotEmpty((String)params)) {
                        s_oper_log.setOper_param(params);
                    }
                } else {
                    Map paramsMap = (Map)ServletUtils.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
                    if (paramsMap != null) {
                        s_oper_log.setOper_param(StringUtils.substring((String)paramsMap.toString(), (int)0, (int)2000));
                    }
                }
            }
            if (logAnnotation.isSaveResponseData() && businessType.isSaveResponse() && jsonResult != null && StringUtils.isNotEmpty((String)(res = JsonUtils.objectToJsonString((Object)jsonResult)))) {
                s_oper_log.setJson_result(StringUtils.substring((String)res, (int)0, (int)2000));
            }
            AsyncManager.me().execute(this.acquireOperateLogTask(s_oper_log));
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(ERROR_LOG, (Throwable)ex);
            }
            this.logger.error(ERROR_LOG + ex.getMessage());
        }
    }

    private String argsArrayToString(Object[] paramsArray) {
        try {
            StringBuilder sb = new StringBuilder();
            if (paramsArray != null && paramsArray.length > 0) {
                for (Object o : paramsArray) {
                    if (o == null || this.isFilterObject(o)) continue;
                    sb.append(JsonUtils.objectToJsonString((Object)o)).append(";");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }

    private TimerTask acquireOperateLogTask(final S_oper_log s_oper_log) {
        return new TimerTask(){

            @Override
            public void run() {
                LogAspect.this.logService.execInsertOperateLog(s_oper_log);
            }
        };
    }
}

