/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support.strategy;

import com.iplatform.base.UserLoginCache;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.core.LoginStrategy;
import com.iplatform.model.po.S_user_login;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginStrategyManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, LoginStrategy> loginStrategyMap = new HashMap<String, LoginStrategy>(4);
    private int count = 0;
    private UserLoginCache userLoginCache;

    public void register(String key, LoginStrategy loginStrategy) {
        if (loginStrategy == null) {
            throw new IllegalArgumentException("loginStrategy\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.loginStrategyMap.containsKey(key)) {
            throw new IllegalArgumentException("loginStrategy\u6ce8\u518c\u91cd\u590d\uff1a" + loginStrategy.getName());
        }
        this.loginStrategyMap.put(key, loginStrategy);
        this.logger.info("\u6ce8\u518c\u3010\u767b\u5f55\u7b56\u7565\u3011\u5bf9\u8c61:{}", (Object)key);
        ++this.count;
    }

    public String execute(RequestLogin requestLogin) {
        if (this.count == 0) {
            return null;
        }
        for (LoginStrategy loginStrategy : this.loginStrategyMap.values()) {
            if (!loginStrategy.isEnabled() || loginStrategy.allowLogin(requestLogin.getUsername(), requestLogin.getClientType())) continue;
            return loginStrategy.acquireError();
        }
        return null;
    }

    public boolean hasUserLogin(String loginId) {
        return this.userLoginCache.getUserLogin(loginId) != null;
    }

    public void putUserLoginCache(S_user_login user_login) {
        this.userLoginCache.putUserLogin(user_login);
    }

    public void updateUserLoginCache(S_user_login user_login) {
        this.userLoginCache.updateUserLogin(user_login);
    }

    public S_user_login getUserLogin(String loginId) {
        return this.userLoginCache.getUserLogin(loginId);
    }

    public void setUserLoginCache(UserLoginCache userLoginCache) {
        this.userLoginCache = userLoginCache;
    }
}

