/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support.strategy;

import com.iplatform.base.support.strategy.MobileOnceLoginStrategy;
import com.iplatform.model.po.S_user_login;
import com.walker.infrastructure.utils.DateUtils;

public class WebOnceLoginStrategy
extends MobileOnceLoginStrategy {
    private long tokenExpireWeb = 600L;

    @Override
    public boolean allowLogin(String loginId, String clientType) {
        if (this.tokenExpireWeb == 0L) {
            throw new IllegalArgumentException("\u8bf7\u5148\u914d\u7f6ebean\u5c5e\u6027\uff1atokenExpireMobile");
        }
        if (!clientType.equals("pc")) {
            return true;
        }
        S_user_login login = this.getUserLoginCache().getUserLogin(loginId);
        if (login == null) {
            this.logger.debug("\u7f13\u5b58\u4e2d\u6ca1\u6709\u767b\u5f55\u8bb0\u5f55\uff0c\u5141\u8bb8\u767b\u5f55\uff0cloginId={}", (Object)loginId);
            return true;
        }
        long spanTime = (System.currentTimeMillis() - DateUtils.toMillSeconds((long)login.getUpdate_time())) / 60000L;
        if (spanTime <= this.tokenExpireWeb) {
            this.logger.debug("\u767b\u5f55\u5728token\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u767b\u5f55\uff0cloginId={}", (Object)login);
            return false;
        }
        return true;
    }

    public long getTokenExpireWeb() {
        return this.tokenExpireWeb;
    }

    public void setTokenExpireWeb(long tokenExpireWeb) {
        this.tokenExpireWeb = tokenExpireWeb;
    }
}

