/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DataImportUtils {
    public static final Object[] calculateInsertAndUpdateList(List<Map<String, Object>> mapList, List<Map<String, Object>> existList, List<String> whereColumnNames) {
        Object[] resultObject = new Object[2];
        if (StringUtils.isEmptyList(existList)) {
            resultObject[0] = mapList;
            resultObject[1] = null;
            return resultObject;
        }
        HashMap<String, Integer> recordExistMap = new HashMap<String, Integer>();
        StringBuilder key = null;
        for (Map<String, Object> existOne : existList) {
            key = new StringBuilder();
            for (String string : whereColumnNames) {
                key.append(existOne.get(string).toString());
            }
            recordExistMap.put(key.toString(), 1);
        }
        ArrayList<Map> insertList = new ArrayList<Map>(256);
        ArrayList<Map> updateList = new ArrayList<Map>(64);
        for (Map map : mapList) {
            key = new StringBuilder();
            for (String whereColumn : whereColumnNames) {
                key.append(map.get(whereColumn).toString());
            }
            if (recordExistMap.get(key.toString()) == null) {
                insertList.add(map);
                continue;
            }
            updateList.add(map);
        }
        resultObject[0] = insertList;
        resultObject[1] = updateList;
        return resultObject;
    }

    public static final List<String> acquireWhereInStringValues(String fieldName, List<Map<String, Object>> mapList) {
        ArrayList<String> valueList = new ArrayList<String>(256);
        Object value = null;
        for (Map<String, Object> map : mapList) {
            value = map.get(fieldName);
            if (value == null) {
                valueList.add("");
                continue;
            }
            valueList.add(value.toString());
        }
        return valueList;
    }

    public static final List<Object[]> acquireUpdateValues(List<Map<String, Object>> dataList, List<String> updateColumns, List<String> whereColumns) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int allValueFieldSize = updateColumns.size() + whereColumns.size();
        Object[] parameter = null;
        for (Map<String, Object> map : dataList) {
            parameter = new Object[allValueFieldSize];
            Object value = null;
            int currentPosition = 0;
            for (int i = 0; i < updateColumns.size(); ++i) {
                parameter[currentPosition] = value = map.get(updateColumns.get(i));
                ++currentPosition;
            }
            for (int j = 0; j < whereColumns.size(); ++j) {
                parameter[currentPosition] = value = map.get(whereColumns.get(j));
                ++currentPosition;
            }
            list.add(parameter);
        }
        return list;
    }

    public static final String acquireUpdateSql(String tableName, List<String> updateColumns, List<String> whereColumns) {
        int i;
        StringBuilder sql = new StringBuilder("update ").append(tableName);
        sql.append(" set ");
        for (i = 0; i < updateColumns.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(updateColumns.get(i)).append("=").append("?");
        }
        if (!StringUtils.isEmptyList(whereColumns)) {
            sql.append(" where ");
            for (i = 0; i < whereColumns.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(whereColumns.get(i)).append("=").append("?");
            }
        }
        return sql.toString();
    }

    public static final List<Object[]> translateToArray(List<Map<String, Object>> mapList, List<String> fieldNames) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(256);
        Object[] parameter = null;
        for (Map<String, Object> map : mapList) {
            parameter = new Object[fieldNames.size()];
            for (int i = 0; i < fieldNames.size(); ++i) {
                parameter[i] = map.get(fieldNames.get(i));
            }
            list.add(parameter);
        }
        return list;
    }

    public static final List<Map<String, Object>> translateToMap(List<Object[]> dataList, List<String> fieldNames) {
        if (StringUtils.isEmptyList(dataList)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(dataList.size() + 2);
        TreeMap<String, Object> map = null;
        for (Object[] row : dataList) {
            map = new TreeMap<String, Object>();
            for (int i = 0; i < row.length; ++i) {
                map.put(fieldNames.get(i), row[i]);
            }
            list.add(map);
        }
        return list;
    }

    public static final String acquireInsertSql(String tableName, List<String> fieldNames) {
        int i;
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(tableName).append("(");
        for (i = 0; i < fieldNames.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(fieldNames.get(i));
        }
        sql.append(") values(");
        for (i = 0; i < fieldNames.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }
}

