/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationConfigVo;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.SmsMessage;
import com.walker.push.util.PushUtils;
import com.walker.push.wx.MessageTemplate;
import com.walker.push.wx.MessageValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationUtils {
    public static final Notification acquireSmsNotification(String templateId, String userPhone, List<Variable> variableList, String title) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        for (Variable variable : variableList) {
            param.put(variable.getId(), variable.getStringValue());
        }
        SmsMessage smsMessage = new SmsMessage();
        smsMessage.setTemplateId(templateId);
        smsMessage.setTemplateParam(param);
        try {
            return PushUtils.acquireSmsNotification((String)title, (String)JsonUtils.objectToJsonString((Object)smsMessage), (String)userPhone, (String)"\u5e73\u53f0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final Notification acquireWechatNotification(String accessToken, String templateId, String userOpenId, List<Variable> variableList) {
        Notification notification = new Notification();
        notification.setId(NumberGenerator.getLongSequenceId());
        notification.setTitle("\u5fae\u4fe1\u516c\u4f17\u53f7\u63a8\u9001");
        notification.setPersistent(true);
        notification.setFrom("\u5e73\u53f0");
        notification.setCreateTime(DateUtils.getDateTimeNumber());
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(NotificationChannel.OfficialAccount);
        notification.setChannelList(channels);
        ArrayList<String> accessTokenList = new ArrayList<String>(2);
        accessTokenList.add(accessToken);
        notification.setReceiverList(accessTokenList);
        notification.setCreator("platform");
        notification.setParallel(false);
        MessageTemplate messageTemplate = new MessageTemplate();
        messageTemplate.setTemplate_id(templateId);
        messageTemplate.setTouser(userOpenId);
        HashMap<String, MessageValue> param = new HashMap<String, MessageValue>(4);
        for (Variable variable : variableList) {
            param.put(variable.getId(), new MessageValue(variable.getStringValue()));
        }
        messageTemplate.setData(param);
        try {
            notification.setContent(JsonUtils.objectToJsonString((Object)messageTemplate));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return notification;
    }

    public static final NotificationConfigVo acquireNotificationConfigVo(SfTemplateMessage templateMessage) {
        NotificationConfigVo vo = new NotificationConfigVo();
        vo.setId(templateMessage.getId());
        vo.setName(templateMessage.getName());
        vo.setTempId(templateMessage.getTempId());
        vo.setTempKey(templateMessage.getTempKey());
        vo.setContent(templateMessage.getContent());
        return vo;
    }

    public static final Object[] acquireMessagePushRules(String messageType) {
        if (StringUtils.isEmpty((String)messageType)) {
            return null;
        }
        messageType = messageType.replace(" ", "");
        Object[] data = new Object[2];
        String[] indexList = null;
        if (messageType.indexOf("&&") > 0) {
            data[0] = true;
            indexList = messageType.split("&&");
        } else if (messageType.indexOf("||") > 0) {
            data[0] = false;
            indexList = messageType.split("\\|\\|");
        } else {
            data[0] = false;
            indexList = new String[]{messageType};
        }
        data[1] = indexList;
        return data;
    }

    public static final Notification acquireSmsValidateCode(String templateId, String code, String targetUserId, String creator) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("code", code);
        return NotificationUtils.acquireSmsNotification(templateId, param, "\u53d1\u9001\u9a8c\u8bc1\u7801", targetUserId, creator);
    }

    public static final Notification acquireSmsNotification(String templateId, Map<String, String> param, String title, String targetUserId, String creator) {
        SmsMessage smsMessage = new SmsMessage();
        smsMessage.setTemplateId(templateId);
        smsMessage.setTemplateParam(param);
        try {
            return PushUtils.acquireSmsNotification((String)title, (String)JsonUtils.objectToJsonString((Object)smsMessage), (String)targetUserId, (String)creator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

