/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.TokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final transient Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private static final long SECONDS_FOR_ONE_MINUTE = 60L;
    private static final long MINUTE_FOR_CACHE_LOGIN_LESS = 5L;

    public static final String generateToken(String userId, String loginId, String uuid, TokenGenerator tokenGenerator, long expiredMinutes) {
        StringBuilder tokenData = new StringBuilder(userId);
        tokenData.append(",");
        tokenData.append(loginId);
        return tokenGenerator.createToken(uuid, tokenData.toString(), expiredMinutes, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB");
    }

    public static final long acquireCacheUserExpiredSeconds(long tokenExpiredMinutes) {
        if (tokenExpiredMinutes <= 0L) {
            throw new IllegalArgumentException("tokenExpiredMinutes \u5fc5\u987b\u5927\u4e8e0");
        }
        if (tokenExpiredMinutes < 5L) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684token\u5931\u6548\u65f6\u95f4(\u5206\u949f)\u8fc7\u77ed:" + tokenExpiredMinutes + ", \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
        }
        return (tokenExpiredMinutes - 5L) * 60L;
    }

    public static final String[] getUserIdAndKey(String tokenData) {
        if (StringUtils.isEmpty((String)tokenData)) {
            return null;
        }
        return tokenData.split(",");
    }

    public static final String getAuthorizationToken(HttpServletRequest request) {
        return TokenUtils.getAuthorizationToken(request, "Authorization");
    }

    public static final String getAuthorizationToken(HttpServletRequest request, String tokenName) {
        String token = request.getHeader(tokenName);
        if (StringUtils.isEmpty((String)token)) {
            token = request.getParameter(tokenName);
        }
        if (StringUtils.isEmpty((String)token)) {
            return null;
        }
        if (token.startsWith("Bearer ")) {
            token = token.replace("Bearer ", "");
        }
        return token;
    }
}

