/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.iplatform.base.PlatformRuntimeException;
import com.walker.infrastructure.utils.Base64Utils;
import com.walker.infrastructure.utils.FileCopyUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class VerifyImgUtil {
    private static int T_WIDTH = 320;
    private static int T_HEIGHT = 180;

    public static Map<String, Integer> generateCutoutCoordinates(int w, int h) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int x = new SecureRandom().nextInt(T_WIDTH - w);
        int y = new SecureRandom().nextInt(T_HEIGHT - h);
        while (x < w + 10) {
            x = new SecureRandom().nextInt(275);
        }
        result.put("x", x);
        result.put("y", y);
        return result;
    }

    public static Map<String, BufferedImage> initSlidingBlock(BufferedImage sourceImg, int[][] templateImgData, int x, int y, int w, int h) throws Exception {
        BufferedImage newTemplateImg = new BufferedImage(w, h, 6);
        for (int i = 0; i < templateImgData.length; ++i) {
            for (int j = 0; j < templateImgData[0].length; ++j) {
                int rgb = templateImgData[i][j];
                if (rgb == 1) {
                    int rgb_ori = sourceImg.getRGB(x + i, y + j);
                    int r = 0xFF & rgb_ori;
                    int g = 0xFF & rgb_ori >> 8;
                    int b = 0xFF & rgb_ori >> 16;
                    rgb_ori = r + (g << 8) + (b << 16) + -16777216;
                    newTemplateImg.setRGB(i, j, rgb_ori);
                    BufferedImage cover = new BufferedImage(10, 10, 1);
                    Graphics2D coverG2 = (Graphics2D)cover.getGraphics();
                    coverG2.setColor(Color.BLACK);
                    coverG2.fillRect(0, 0, 10, 10);
                    coverG2.dispose();
                    Graphics2D bgG2 = (Graphics2D)sourceImg.getGraphics();
                    bgG2.setComposite(AlphaComposite.getInstance(10, 0.5f));
                    bgG2.drawImage(cover, i + x, y + j, 1, 1, null);
                    bgG2.setComposite(AlphaComposite.getInstance(3));
                    bgG2.dispose();
                }
                if (rgb == 0) {
                    // empty if block
                }
                if (rgb != 2) continue;
                newTemplateImg.setRGB(i, j, 0xFFFFFF);
                sourceImg.setRGB(x + i, y + j, 0xFFFFFF);
            }
        }
        HashMap<String, BufferedImage> result = new HashMap<String, BufferedImage>();
        result.put("newTemplateImg", newTemplateImg);
        result.put("newSourceImg", sourceImg);
        return result;
    }

    public static String getBase64(BufferedImage bi) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Object res = "";
        try {
            ImageIO.write((RenderedImage)bi, "png", outputStream);
            res = Base64Utils.encode((byte[])outputStream.toByteArray());
            res = "data:image/png;base64," + (String)res;
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("\u9a8c\u8bc1\u7801\u56fe\u7247\u4f20base64\u9519\u8bef:" + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }

    public static String getBase64Image(String base64) {
        return "data:image/png;base64," + base64;
    }

    public static int[][] getTemplateData(BufferedImage bi) {
        int[][] data = new int[bi.getWidth()][bi.getHeight()];
        for (int i = 0; i < bi.getWidth(); ++i) {
            for (int j = 0; j < bi.getHeight(); ++j) {
                int rgb = bi.getRGB(i, j);
                int leftRgb = -1;
                int rightRgb = -1;
                int upRgb = -1;
                int downRgb = -1;
                if (j > 0) {
                    leftRgb = bi.getRGB(i, j - 1);
                }
                if (j < bi.getHeight() - 1) {
                    rightRgb = bi.getRGB(i, j + 1);
                }
                if (i > 0) {
                    upRgb = bi.getRGB(i - 1, j);
                }
                if (i < bi.getWidth() - 1) {
                    downRgb = bi.getRGB(i + 1, j);
                }
                data[i][j] = rgb == -1 && (i == 0 || i == bi.getWidth() - 1 || j == 0 || j == bi.getHeight() - 1) ? 2 : (rgb == -1 && (leftRgb != -1 || rightRgb != -1 || upRgb != -1 || downRgb != -1) ? 2 : (rgb == -1 ? 1 : 0));
            }
        }
        return data;
    }

    public static BufferedImage getBase64StrToImage(String base64String) {
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bytes = Base64Utils.decode((String)base64String);
            inputStream = new ByteArrayInputStream(bytes);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("\u9a8c\u8bc1\u7801base64\u8f6c\u6587\u4ef6\u9519\u8bef:" + e.getMessage(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeBase64ToFile(String base64String, File outFile) {
        BufferedOutputStream outputStream = null;
        try {
            byte[] bytes = Base64Utils.decode((String)base64String);
            outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
            FileCopyUtils.copy((byte[])bytes, (OutputStream)outputStream);
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("\u6587\u4ef6base64\u4fdd\u5b58\u6587\u4ef6\u9519\u8bef:" + ex.getMessage() + ", file=" + outFile.getAbsolutePath(), ex);
        }
    }
}

