/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.ThirdPartyManager;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.core.BeanContextAware;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.FileUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractController
implements InitializingBean {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String contextPath;
    private static final Object lock;
    protected static final String DEFAULT_JS_NAME = "reload";
    protected static final String DEFAULT_PAGER_VIEW_NAME = "pagerView";

    protected ThirdPartyManager getThirdPartyManager() {
        return (ThirdPartyManager)BeanContextAware.getBeanByType(ThirdPartyManager.class);
    }

    protected String getServerDomain() {
        HttpServletRequest request = this.getRequest();
        return ServletUtils.getServerDomain((HttpServletRequest)request);
    }

    protected <T> T getPlatformCallback(Class<T> clazz) {
        return PlatformCallbackPostProcessor.getCallbackObject(clazz);
    }

    protected Variable getArgumentVariable(String key) {
        Variable v = this.getArgumentManager().getVariable(key);
        if (v == null) {
            throw new IllegalArgumentException("\u53ef\u53d8\u914d\u7f6e\u53c2\u6570\u4e0d\u5b58\u5728: " + key);
        }
        return v;
    }

    protected ArgumentsManager getArgumentManager() {
        return (ArgumentsManager)BeanContextAware.getBeanByType(ArgumentsManager.class);
    }

    protected void downloadSimpleFile(byte[] data, String fileName) throws IOException {
        HttpServletResponse response = this.getResponse();
        response.reset();
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }

    @Deprecated
    protected PageSearch preparePageSearch() {
        Integer pageSize;
        PageSearch pageSearch = new PageSearch();
        Integer pn = this.getIntParameter("pageNum");
        if (pn != null) {
            pageSearch.setPageIndex(pn.intValue());
        }
        if ((pageSize = this.getIntParameter("pageSize")) != null) {
            pageSearch.setPageSize(pageSize.intValue());
        }
        pageSearch.setOrderByColumn(this.getParameter("orderByColumn"));
        pageSearch.setOrderAsc(this.getParameter("isAsc"));
        ListPageContext.setPageSearch((PageSearch)pageSearch);
        return pageSearch;
    }

    protected long getParamsDateTime(String dateTime, boolean isTime) {
        if (StringUtils.isEmpty((String)dateTime)) {
            return -1L;
        }
        if (isTime) {
            return DateUtils.getDateTimeNumber((String)dateTime);
        }
        return DateUtils.toLongDateTime((String)dateTime);
    }

    @Deprecated
    protected <T> ResponseValue<List<?>> acquireTablePage(List<T> data, long total) {
        ResponseValue rv = ResponseValue.success(data);
        rv.setTotal(total);
        return rv;
    }

    protected HttpServletRequest getRequest() {
        return ServletUtils.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletUtils.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContextPath() {
        if (contextPath == null) {
            Object object = lock;
            synchronized (object) {
                HttpServletRequest request = this.getRequest();
                if (request == null) {
                    throw new Error("request not found: getRequest().");
                }
                contextPath = request.getContextPath();
            }
        }
        return contextPath;
    }

    protected String getParameter(String name) {
        return this.getRequest().getParameter(name);
    }

    protected String getParameterUTF8(String name) throws UnsupportedEncodingException {
        String value = this.getParameter(name);
        return value == null ? null : URLDecoder.decode(value, "UTF-8");
    }

    protected String[] getParameterValues(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected Integer getIntParameter(String name) {
        String value = this.getParameter(name);
        return value == null ? null : Integer.valueOf(value);
    }

    protected Long getLongParameter(String name) {
        String value = this.getParameter(name);
        return value == null ? null : Long.valueOf(value);
    }

    protected Float getFloatParameter(String name) {
        String value = this.getParameter(name);
        return value == null ? null : Float.valueOf(value);
    }

    protected Double getDoubleParameter(String name) {
        String value = this.getParameter(name);
        return value == null ? null : Double.valueOf(value);
    }

    protected Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    protected void setAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    protected void setDefaultContentType() {
        this.getResponse().setContentType("text/html; charset=utf-8");
    }

    private void ajaxOutPut(ResponseFormat format, Object outputString) throws IOException {
        HttpServletResponse response = this.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType(format.getValue());
        this.print(response, outputString == null ? "" : outputString.toString());
    }

    protected void print(HttpServletResponse response, String str) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.print(str);
    }

    protected void ajaxOutPutText(Object outputString) throws IOException {
        this.ajaxOutPut(ResponseFormat.TextPlain, outputString);
    }

    protected void ajaxOutPutJson(Object outputString) throws IOException {
        this.ajaxOutPut(ResponseFormat.ApplicationJson, outputString);
    }

    protected void ajaxOutPutXml(Object outputString) throws IOException {
        this.ajaxOutPut(ResponseFormat.TextXml, outputString);
    }

    protected void ajaxOutPutHtml(Object outputString) throws IOException {
        this.setDefaultContentType();
        this.print(this.getResponse(), outputString == null ? "" : outputString.toString());
    }

    protected void ajaxOutputFileStream(String contentType, String filePath) {
        this.ajaxOutputFileStream(contentType, new File(filePath));
    }

    protected void ajaxOutputFileStream(String contentType, File file) {
        HttpServletResponse response = this.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        byte[] content = FileUtils.getFileBytes((File)file);
        if (content == null) {
            return;
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("\u8f93\u51fa\u670d\u52a1\u5668\u6587\u4ef6\u6d41\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        lock = new Object();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ResponseFormat {
        ApplicationJson{

            @Override
            public String getValue() {
                return "application/json;charset=UTF-8";
            }
        }
        ,
        ApplicationXml{

            @Override
            public String getValue() {
                return "application/xml;charset=UTF-8";
            }
        }
        ,
        TextXml{

            @Override
            public String getValue() {
                return "text/xml;charset=UTF-8";
            }
        }
        ,
        TextPlain{

            @Override
            public String getValue() {
                return "text/plain;charset=UTF-8";
            }
        };


        public String getValue() {
            throw new AbstractMethodError();
        }
    }
}

