/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.SystemController;
import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.form.FormDataItem;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_group_data;
import com.iplatform.model.vo.SystemGroupVo;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PlatformAdapterController
extends SystemController {
    protected SystemGroupCache getSystemGroupCache() {
        return (SystemGroupCache)BeanContextAware.getBeanByType(SystemGroupCache.class);
    }

    private GroupServiceImpl getGroupService() {
        return (GroupServiceImpl)((Object)BeanContextAware.getBeanByType(GroupServiceImpl.class));
    }

    protected <T> T acquireGroupDataNormal(int groupDataId, Class<T> clazz, String cdnUrl) {
        S_group_data groupData = this.getGroupService().queryGroupData(groupDataId);
        if (groupData == null || groupData.getStatus() == 0) {
            return null;
        }
        try {
            FormData formData = (FormData)JsonUtils.jsonStringToObject((String)groupData.getValue(), FormData.class);
            if (StringUtils.isEmptyList(formData.getFields())) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (FormDataItem item : formData.getFields()) {
                if (item.getName().equals("pic")) {
                    map.put(item.getName(), cdnUrl + item.getValue());
                    continue;
                }
                map.put(item.getName(), item.getValue());
            }
            map.put("id", groupData.getId());
            String json = JsonUtils.objectToJsonString(map);
            return (T)JsonUtils.jsonStringToObject((String)json, clazz);
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("S_group_data.value\u8f6cFormData\u9519\u8bef\uff1a" + ex.getMessage(), ex);
        }
    }

    protected <T> List<T> acquireGroupDataList(int groupId, boolean status, Class<T> clazz, String cdnUrl) {
        SystemGroupVo vo = this.getSystemGroupCache().get(groupId);
        if (vo == null) {
            throw new IllegalStateException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u5206\u7ec4\u8bb0\u5f55\uff0cgroupId = " + groupId);
        }
        List groupDataList = vo.getGroupDataList();
        if (StringUtils.isEmptyList((List)groupDataList)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            FormData formData = null;
            for (S_group_data data : groupDataList) {
                formData = (FormData)JsonUtils.jsonStringToObject((String)data.getValue(), FormData.class);
                if (StringUtils.isEmptyList(formData.getFields()) || status && data.getStatus() == 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (FormDataItem item : formData.getFields()) {
                    if (item.getName().equals("pic")) {
                        map.put(item.getName(), cdnUrl + item.getValue());
                        continue;
                    }
                    map.put(item.getName(), item.getValue());
                }
                map.put("id", data.getId());
                String json = JsonUtils.objectToJsonString(map);
                Object t = JsonUtils.jsonStringToObject((String)json, clazz);
                arrayList.add(t);
            }
            return arrayList;
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("S_group_data.value\u8f6cFormData\u9519\u8bef\uff1a" + ex.getMessage(), ex);
        }
    }

    protected List<HashMap<String, Object>> acquireGroupDataConfigList(int groupId, String cdnUrl) {
        SystemGroupVo vo = this.getSystemGroupCache().get(groupId);
        if (vo == null) {
            throw new IllegalStateException("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u5206\u7ec4\u8bb0\u5f55\uff0cgroupId = " + groupId);
        }
        List groupDataList = vo.getGroupDataList();
        if (StringUtils.isEmptyList((List)groupDataList)) {
            return new ArrayList<HashMap<String, Object>>(1);
        }
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        try {
            FormData formData = null;
            for (S_group_data data : groupDataList) {
                formData = (FormData)JsonUtils.jsonStringToObject((String)data.getValue(), FormData.class);
                if (StringUtils.isEmptyList(formData.getFields())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (FormDataItem item : formData.getFields()) {
                    if (item.getName().equals("pic")) {
                        map.put(item.getName(), cdnUrl + item.getValue());
                        continue;
                    }
                    map.put(item.getName(), item.getValue());
                }
                map.put("id", data.getId());
                arrayList.add(map);
            }
            return arrayList;
        }
        catch (Exception ex) {
            throw new PlatformRuntimeException("S_group_data.value\u8f6cFormData\u9519\u8bef\uff1a" + ex.getMessage(), ex);
        }
    }
}

