/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.WechatCacheProvider;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.base.util.RestTemplateUtils;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.vo.NotificationTemplateVo;
import com.iplatform.model.vo.WeChatAccessTokenVo;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import java.text.MessageFormat;
import java.util.List;
import org.springframework.web.client.RestTemplate;

public abstract class WechatBaseController
extends PlatformAdapterController {
    protected void pushNotificationWithTemplate(String mark, List<Variable> variableList, long userId) {
        if (StringUtils.isEmpty((String)mark)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8f93\u5165\u901a\u77e5\u6a21\u677f\u6807\u8bb0\uff1amark");
        }
        if (StringUtils.isEmptyList(variableList)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8f93\u5165\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u6570\u636e\uff1avariableList");
        }
        NotificationTemplateVo templateVo = this.getNotificationTemplateCache().get(mark);
        if (templateVo == null) {
            this.logger.error("\u901a\u77e5\u6a21\u677f\u7f13\u5b58\u4e0d\u5b58\u5728\uff0cmark={}", (Object)mark);
            return;
        }
        if (templateVo.getWechat()) {
            String openId = this.getUser(userId).getWx_open_id();
            if (StringUtils.isEmpty((String)openId)) {
                this.logger.error("\u7528\u6237openId\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u901a\u77e5, userId={}", (Object)userId);
                return;
            }
            String accessToken = this.acquirePublicAccessToken();
            if (StringUtils.isEmpty((String)accessToken)) {
                this.logger.error("\u63a8\u9001\u516c\u4f17\u53f7\u6d88\u606f\u5931\u8d25\uff0caccessToken\u83b7\u53d6\u4e3a\u7a7a\uff0cmark={}, userId={}", (Object)mark, (Object)userId);
                return;
            }
            Notification notification = NotificationUtils.acquireWechatNotification(accessToken, templateVo.getWechatTempId(), openId, variableList);
            this.getPushManager().push(notification, null);
        }
        if (templateVo.getSms()) {
            String userPhone = this.getUser(userId).getPhonenumber();
            if (StringUtils.isEmpty((String)userPhone)) {
                this.logger.error("\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\u901a\u77e5, userId={}", (Object)userId);
                return;
            }
            Notification smsNotification = NotificationUtils.acquireSmsNotification(templateVo.getSmsTempId(), userPhone, variableList, "\u77ed\u4fe1\u901a\u77e5");
            this.getPushManager().push(smsNotification, null);
        }
        if (templateVo.getRoutine()) {
            throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6d88\u606f\u901a\u77e5");
        }
    }

    protected String acquireMiniAccessToken() {
        String appId = this.getArgumentVariable("routine_appid").getStringValue();
        if (StringUtils.isEmpty((String)appId)) {
            throw new PlatformRuntimeException("\u8bf7\u5148\u914d\u7f6e\u5fae\u4fe1\u53c2\u6570:\u5c0f\u7a0b\u5e8fappid");
        }
        String miniAccessToken = this.getWechatCache().getMiniAccessToken();
        if (StringUtils.isNotEmpty((String)miniAccessToken)) {
            this.logger.debug("\u7f13\u5b58\u4e2d\u5df2\u6709'access_token'\uff1a{}", (Object)miniAccessToken);
            return miniAccessToken;
        }
        String secret = this.getArgumentVariable("routine_appsecret").getStringValue();
        if (StringUtils.isEmpty((String)secret)) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8fsecret\u672a\u8bbe\u7f6e");
        }
        ObjectNode objectNode = this.acquireAccessTokenNode(appId, secret);
        WeChatAccessTokenVo accessTokenVo = null;
        try {
            this.checkStatusError(objectNode);
            accessTokenVo = new WeChatAccessTokenVo();
            accessTokenVo.setAccessToken(objectNode.get("access_token").asText());
            accessTokenVo.setExpiresIn(Integer.valueOf(objectNode.get("expires_in").asInt()));
            this.getWechatCache().putMiniAccessToken(accessTokenVo.getAccessToken(), accessTokenVo.getExpiresIn().longValue() - 1800L);
            this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'mini_accessToken'\uff0c\u5e76\u7f13\u5b58\uff1a{}", (Object)accessTokenVo.getAccessToken());
            return accessTokenVo.getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, e);
        }
    }

    protected String acquirePublicAccessToken() {
        String appId = this.getArgumentVariable("wechat_appid").getStringValue();
        if (StringUtils.isEmpty((String)appId)) {
            throw new PlatformRuntimeException("\u8bf7\u5148\u914d\u7f6e\u5fae\u4fe1\u53c2\u6570:\u516c\u4f17\u53f7appid");
        }
        String publicAccessToken = this.getWechatCache().getPublicAccessToken();
        if (StringUtils.isNotEmpty((String)publicAccessToken)) {
            this.logger.debug("\u7f13\u5b58\u4e2d\u5df2\u6709'access_token'\uff1a{}", (Object)publicAccessToken);
            return publicAccessToken;
        }
        String secret = this.getArgumentVariable("wechat_appsecret").getStringValue();
        if (StringUtils.isEmpty((String)secret)) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u516c\u4f17\u53f7secret\u672a\u8bbe\u7f6e");
        }
        ObjectNode objectNode = this.acquireAccessTokenNode(appId, secret);
        WeChatAccessTokenVo accessTokenVo = null;
        try {
            this.checkStatusError(objectNode);
            accessTokenVo = new WeChatAccessTokenVo();
            accessTokenVo.setAccessToken(objectNode.get("access_token").asText());
            accessTokenVo.setExpiresIn(Integer.valueOf(objectNode.get("expires_in").asInt()));
            this.getWechatCache().putPublicAccessToken(accessTokenVo.getAccessToken(), accessTokenVo.getExpiresIn().longValue() - 1800L);
            this.logger.info("\u8c03\u7528\u4e00\u6b21\u5fae\u4fe1\u8fdc\u7a0b\u63a5\u53e3\u83b7\u53d6'public_accessToken'\uff0c\u5e76\u7f13\u5b58\uff1a{}", (Object)accessTokenVo.getAccessToken());
            return accessTokenVo.getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + objectNode, e);
        }
    }

    private ObjectNode acquireAccessTokenNode(String appId, String secret) {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}", appId, secret);
        this.logger.debug("url = {}", (Object)url);
        ObjectNode objectNode = RestTemplateUtils.getData(url, (RestTemplate)BeanContextAware.getBeanByType(RestTemplate.class));
        if (objectNode == null) {
            throw new PlatformRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        this.logger.debug(objectNode.toString());
        return objectNode;
    }

    private void checkStatusError(ObjectNode objectNode) {
        if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0")) {
            if (objectNode.has("errmsg")) {
                throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode") + objectNode.get("errmsg"));
            }
            throw new PlatformRuntimeException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + objectNode.get("errcode"));
        }
    }

    protected WechatCacheProvider getWechatCache() {
        return (WechatCacheProvider)BeanContextAware.getBeanByType(WechatCacheProvider.class);
    }
}

