/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.api;

import com.iplatform.base.SystemController;
import com.iplatform.core.httpapi.ApiEngine;
import com.iplatform.core.httpapi.ApiRequest;
import com.walker.web.ResponseValue;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote/http"})
public class HttpEngineApi
extends SystemController {
    private ApiEngine apiEngine;
    private static final String KEY_APP_ID = "appId";
    private static final String KEY_API_ID = "apiInfoId";

    @Autowired
    public HttpEngineApi(ApiEngine apiEngine) {
        this.apiEngine = apiEngine;
    }

    @RequestMapping(value={"/invoke"}, method={RequestMethod.POST})
    public ResponseValue index(@RequestBody Map<String, String> data) {
        if (data == null || data.get(KEY_APP_ID) == null || data.get(KEY_API_ID) == null) {
            return ResponseValue.error((String)"\u8bf7\u63d0\u4f9b\u5fc5\u8981\u53c2\u6570\uff1aappId|appInfoId");
        }
        this.logger.debug("\u8c03\u7528\u65b9\u662f\uff1a{}\uff0c\u8c03\u7528\u63a5\u53e3\u662f\uff1a{}", (Object)data.get(KEY_APP_ID).toString(), (Object)data.get(KEY_API_ID).toString());
        ApiRequest apiRequest = this.acquireApiRequest(data);
        try {
            return this.apiEngine.execute(apiRequest);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return ResponseValue.error((String)ex.getMessage());
        }
    }

    private ApiRequest acquireApiRequest(Map<String, String> data) {
        ApiRequest request = new ApiRequest();
        request.setAppId(data.get(KEY_APP_ID).toString());
        request.setApiInfoId(data.get(KEY_API_ID).toString());
        data.remove(KEY_APP_ID);
        data.remove(KEY_API_ID);
        request.setData(data);
        return request;
    }
}

