/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.util.DeptUtils;
import com.iplatform.model.po.S_dept;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalDeptCacheProvider
extends AbstractCacheProvider<S_dept>
implements DeptCacheProvider {
    private DeptServiceImpl deptService;
    private Map<String, List<String>> deptChildrenIdList = new ConcurrentHashMap<String, List<String>>();

    public void setDeptService(DeptServiceImpl deptService) {
        this.deptService = deptService;
    }

    @Override
    public void setAllowCacheChildren(boolean allow) {
    }

    @Override
    public S_dept getDept(long deptId) {
        if (deptId == 0L) {
            return DeptUtils.SUPER_VISOR_DEPT;
        }
        return (S_dept)this.getCacheData(String.valueOf(deptId));
    }

    @Override
    public void updateDept(S_dept s_dept) {
        this.updateCacheData(String.valueOf(s_dept.getId()), s_dept);
    }

    @Override
    public void removeDept(long deptId) {
        String key = String.valueOf(deptId);
        String keyChildren = key + ".children";
        S_dept current = this.getDept(deptId);
        if (current == null) {
            logger.warn("\u673a\u6784\u7f13\u5b58\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664");
            return;
        }
        this.removeCacheData(keyChildren);
        this.removeCacheData(key);
        List<String> parentChildrenList = this.getChildrenDeptIdOneLevel(current.getParent_id());
        if (parentChildrenList != null) {
            parentChildrenList.remove(key);
        }
    }

    @Override
    public void putDept(S_dept s_dept) {
        String id = String.valueOf(s_dept.getId());
        try {
            this.putCacheData(id, s_dept);
            this.deptChildrenIdList.put(id + ".children", new ArrayList());
            if (s_dept.getParent_id() == 0L) {
                logger.debug("\u9876\u7ea7\u673a\u6784\uff0c\u4e0d\u7528\u66f4\u65b0\u7236\u673a\u6784\u5217\u8868, " + id);
                return;
            }
            List<String> parentChildrenList = this.getChildrenDeptIdOneLevel(s_dept.getParent_id());
            if (StringUtils.isEmptyList(parentChildrenList)) {
                parentChildrenList = new ArrayList<String>();
            }
            parentChildrenList.add(id);
            this.deptChildrenIdList.put(String.valueOf(s_dept.getParent_id()) + ".children", parentChildrenList);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0 [\u673a\u6784] \u7f13\u5b58\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildrenDeptIdOneLevel(long deptId) {
        String key = deptId + ".children";
        List<String> childrenIdList = this.deptChildrenIdList.get(key);
        if (childrenIdList == null) {
            logger.error("\u672a\u627e\u5230\u7f13\u5b58\u4e2d\u5b50\u673a\u6784\u5217\u8868: " + key);
            return null;
        }
        return childrenIdList;
    }

    @Override
    public List<S_dept> getChildrenDeptOneLevel(long deptId) {
        List<String> childrenIdList = this.getChildrenDeptIdOneLevel(deptId);
        if (StringUtils.isEmptyList(childrenIdList)) {
            return null;
        }
        ArrayList<S_dept> resultList = new ArrayList<S_dept>();
        S_dept s_dept = null;
        for (String id : childrenIdList) {
            s_dept = this.getDept(Long.parseLong(id));
            resultList.add(s_dept);
        }
        return resultList;
    }

    protected int loadDataToCache(Cache cache) {
        List<S_dept> list = this.deptService.queryAllDeptListForCache();
        if (!StringUtils.isEmptyList(list)) {
            for (S_dept h : list) {
                this.putDept(h);
            }
            return list.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.dept";
    }

    public Class<?> getProviderType() {
        return S_dept.class;
    }
}

