/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.util.CategoryUtils;
import com.iplatform.base.util.cache.CategorySortComparator;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class RedisCategoryCacheProvider
extends RedisCacheProvider<S_category>
implements CategoryCacheProvider {
    private final CategorySortComparator sortComparator = new CategorySortComparator();
    private CategoryServiceImpl categoryService;

    public RedisCategoryCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.categoryService.selectAll((BasePo)new S_category());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2dCategory\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (S_category h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList, int owner) {
        ArrayList<S_category> allTree = new ArrayList<S_category>();
        S_category tempCategory = null;
        for (String value : ((RedisCache)this.getCache()).getIterator(null)) {
            try {
                tempCategory = (S_category)JsonUtils.jsonStringToObject((String)value, S_category.class);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException("redis\u5b58\u50a8'S_category'\u89e3\u6790\u9519\u8bef\uff1a" + value, (Throwable)ex);
            }
            if (!CategoryUtils.isCondition(tempCategory, type, status, name, categoryIdList, owner)) continue;
            allTree.add(tempCategory);
        }
        return CategoryUtils.acquireListTree(allTree, this.sortComparator);
    }

    @Override
    public List<CategoryTreeVo> getListTree(Integer type, Integer status, String name, int owner) {
        if (StringUtils.isNotEmpty((String)name)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getTree(type, status, name, null, owner);
    }

    @Override
    public S_category get(int id) {
        return (S_category)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(S_category category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(S_category category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.base.category";
    }

    public Class<?> getProviderType() {
        return S_category.class;
    }

    public void setCategoryService(CategoryServiceImpl categoryService) {
        this.categoryService = categoryService;
    }
}

