/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.util.DeptUtils;
import com.iplatform.model.po.S_dept;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.List;

public class RedisDeptCacheProvider
extends RedisCacheProvider<String>
implements DeptCacheProvider {
    private boolean allowCacheChildren = true;
    private DeptServiceImpl deptService;

    public void setDeptService(DeptServiceImpl deptService) {
        this.deptService = deptService;
    }

    public RedisDeptCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public void setAllowCacheChildren(boolean allow) {
        this.allowCacheChildren = allow;
    }

    @Override
    public S_dept getDept(long deptId) {
        if (deptId == 0L) {
            return DeptUtils.SUPER_VISOR_DEPT;
        }
        String data = (String)this.getCacheData(String.valueOf(deptId));
        if (StringUtils.isEmpty((String)data)) {
            logger.error("\u67e5\u8be2\u673a\u6784\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u52a0\u8f7d:" + deptId);
            S_dept s_dept = this.deptService.queryOneDept(deptId);
            if (s_dept == null) {
                throw new IllegalStateException("\u6570\u636e\u5e93\u52a0\u8f7d\u673a\u6784\u4e0d\u5b58\u5728\uff0cid=" + deptId);
            }
            try {
                if (this.allowCacheChildren) {
                    this.putDept(s_dept);
                } else {
                    this.putCacheData(String.valueOf(deptId), JsonUtils.objectToJsonString((Object)s_dept));
                }
                return s_dept;
            }
            catch (Exception ex) {
                throw new RuntimeException("\u6dfb\u52a0 [\u673a\u6784] \u7f13\u5b58\u9519\u8bef:" + ex.getMessage(), ex);
            }
        }
        try {
            return (S_dept)JsonUtils.jsonStringToObject((String)data, S_dept.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u5f97\u673a\u6784\u7f13\u5b58\u9519\u8bef:" + deptId + ", " + e.getMessage(), e);
        }
    }

    @Override
    public void updateDept(S_dept s_dept) {
        try {
            this.updateCacheData(String.valueOf(s_dept.getId()), JsonUtils.objectToJsonString((Object)s_dept));
        }
        catch (Exception e) {
            throw new RuntimeException("\u66f4\u65b0\u673a\u6784\u7f13\u5b58\u9519\u8bef:" + s_dept.getId() + ", " + e.getMessage(), e);
        }
    }

    @Override
    public void removeDept(long deptId) {
        String key = String.valueOf(deptId);
        String keyChildren = key + ".children";
        S_dept current = this.getDept(deptId);
        if (current == null) {
            logger.warn("\u673a\u6784\u7f13\u5b58\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664");
            return;
        }
        this.removeCacheData(keyChildren);
        this.removeCacheData(key);
        if (current.getParent_id() == 0L) {
            return;
        }
        if (this.allowCacheChildren) {
            String parentId = String.valueOf(current.getParent_id());
            List<String> parentChildrenList = this.getChildrenDeptIdOneLevel(current.getParent_id());
            if (parentChildrenList != null) {
                parentChildrenList.remove(String.valueOf(deptId));
                try {
                    this.updateCacheData(parentId + ".children", JsonUtils.objectToJsonString(parentChildrenList));
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5220\u9664\u673a\u6784\u7f13\u5b58\u65f6\uff0c\u66f4\u65b0\u7236\u8282\u70b9childrenList\u62a5\u9519:" + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void putDept(S_dept s_dept) {
        String id = String.valueOf(s_dept.getId());
        try {
            this.putCacheData(id, JsonUtils.objectToJsonString((Object)s_dept));
            if (this.allowCacheChildren) {
                this.putCacheData(id + ".children", JsonUtils.objectToJsonString(new ArrayList(2)));
            }
            if (s_dept.getParent_id() == 0L) {
                logger.debug("\u9876\u7ea7\u673a\u6784\uff0c\u4e0d\u7528\u66f4\u65b0\u7236\u673a\u6784\u5217\u8868, " + id);
                return;
            }
            if (this.allowCacheChildren) {
                List<String> parentChildrenList = this.getChildrenDeptIdOneLevel(s_dept.getParent_id());
                if (StringUtils.isEmptyList(parentChildrenList)) {
                    parentChildrenList = new ArrayList<String>();
                }
                parentChildrenList.add(id);
                this.updateCacheData(String.valueOf(s_dept.getParent_id()) + ".children", JsonUtils.objectToJsonString(parentChildrenList));
                if (logger.isDebugEnabled()) {
                    logger.debug("\u6dfb\u52a0\u673a\u6784\u7f13\u5b58\uff0cparentChildrenList = " + parentChildrenList);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0 [\u673a\u6784] \u7f13\u5b58\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildrenDeptIdOneLevel(long deptId) {
        if (this.allowCacheChildren) {
            String key = String.valueOf(deptId) + ".children";
            String data = (String)this.getCacheData(key);
            if (StringUtils.isEmpty((String)data)) {
                logger.error("\u672a\u627e\u5230\u7f13\u5b58\u4e2d\u5b50\u673a\u6784\u5217\u8868: " + key);
                return null;
            }
            try {
                return (List)JsonUtils.jsonStringToObject((String)data, List.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u4ee3\u7801\uff1a\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\uff1a" + deptId + " \u4e0b\u4e00\u7ea7\u6240\u6709\u5b50\u673a\u6784ID\u96c6\u5408");
    }

    @Override
    public List<S_dept> getChildrenDeptOneLevel(long deptId) {
        List<String> childrenIdList = this.getChildrenDeptIdOneLevel(deptId);
        if (StringUtils.isEmptyList(childrenIdList)) {
            return null;
        }
        ArrayList<S_dept> resultList = new ArrayList<S_dept>();
        S_dept s_dept = null;
        for (String id : childrenIdList) {
            s_dept = this.getDept(Long.parseLong(id));
            resultList.add(s_dept);
        }
        return resultList;
    }

    public String getProviderName() {
        return "cache.base.dept";
    }

    public Class<?> getProviderType() {
        return String.class;
    }
}

