/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.cache;

import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.model.po.S_user_core;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public class RedisUserCacheProvider
extends RedisCacheProvider<S_user_core>
implements UserCacheProvider {
    private UserServiceImpl userService = null;
    private boolean allowInitCache = true;

    public void setAllowInitCache(boolean allowInitCache) {
        this.allowInitCache = allowInitCache;
    }

    public void setUserService(UserServiceImpl userService) {
        this.userService = userService;
    }

    public RedisUserCacheProvider() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public String getProviderName() {
        return "cache.base.user";
    }

    public Class<?> getProviderType() {
        return S_user_core.class;
    }

    protected int loadDataToCache(Cache cache) {
        if (this.allowInitCache) {
            List hosts = this.userService.selectAll((BasePo)new S_user_core());
            if (!StringUtils.isEmptyList((List)hosts)) {
                long totalCache;
                if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                    logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();
                    for (S_user_core h : hosts) {
                        cache.put(String.valueOf(h.getId()), (Object)h);
                    }
                }
                return hosts.size();
            }
        } else {
            logger.info("........\u7531\u4e8e\u7528\u6237\u91cf\u8f83\u5927\uff0c\u6240\u4ee5\u914d\u7f6e\uff1a\u4e0d\u9700\u8981\u521d\u59cb\u5316\u52a0\u8f7d\u7528\u6237\u7f13\u5b58!");
        }
        return 0;
    }

    @Override
    public S_user_core getUser(long userId) {
        S_user_core user_core = (S_user_core)this.getCacheData(String.valueOf(userId));
        if (user_core == null) {
            logger.warn("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u7528\u6237\u5bf9\u8c61\uff0c\u5c1d\u8bd5\u4ece\u6570\u636e\u5e93\u52a0\u8f7d, userId = " + userId);
            user_core = (S_user_core)this.userService.get((BasePo)new S_user_core(Long.valueOf(userId)));
            this.putCacheData(String.valueOf(userId), user_core);
        }
        return user_core;
    }

    @Override
    public void updateUser(S_user_core user_core) {
        if (user_core == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u7528\u6237\u7f13\u5b58\u9519\u8bef\uff0cuser_core = null");
        }
        this.updateCacheData(String.valueOf(user_core.getId()), user_core);
    }

    @Override
    public void removeUser(long userId) {
        this.removeCacheData(String.valueOf(userId));
    }

    @Override
    public void putUser(S_user_core user_core) {
        if (user_core == null) {
            throw new IllegalArgumentException("\u6dfb\u52a0\u7528\u6237\u7f13\u5b58\u9519\u8bef: user_core = null");
        }
        this.putCacheData(String.valueOf(user_core.getId()), user_core);
    }
}

