/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.callback;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.TokenUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralLoginCallback
implements PlatformLoginCallback {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private CaptchaProvider<CaptchaResult> captchaProvider;
    protected UserServiceImpl userService = null;
    private UserOnlineProvider userOnlineProvider;
    private TokenGenerator tokenGenerator;

    @Override
    public boolean isValidateCaptcha() {
        CaptchaProvider<CaptchaResult> captchaProvider = this.getCaptchaProvider();
        if (captchaProvider == null) {
            this.logger.warn("\u767b\u5f55\u56de\u8c03'{}'\u6ca1\u6709\u914d\u7f6e'\u9a8c\u8bc1\u7801\u63d0\u4f9b\u8005':CaptchaProvider", (Object)this.getClass().getName());
            return false;
        }
        CaptchaType captchaType = captchaProvider.getCaptchaType();
        this.logger.debug("captchaType = {}", (Object)captchaType);
        if (captchaType == CaptchaType.Slide) {
            this.logger.debug("slide \u9a8c\u8bc1\u7c7b\u578b\uff0c\u540e\u53f0\u4e0d\u9700\u8981\u6821\u9a8c\u3002");
            return false;
        }
        if (captchaType == CaptchaType.SmsCode) {
            return false;
        }
        return captchaType != CaptchaType.None;
    }

    public boolean supportMultiple() {
        return true;
    }

    @Override
    @Deprecated
    public void onLogout(String token) throws TokenException {
        String data = this.tokenGenerator.validateToken(token, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB");
        String[] userIdAndKey = TokenUtils.getUserIdAndKey(data);
        this.userOnlineProvider.removeUserPrincipal(userIdAndKey[1]);
        this.logger.debug("\u7528\u6237 logout success: " + userIdAndKey[0]);
    }

    public void setUserOnlineProvider(UserOnlineProvider userOnlineProvider) {
        this.userOnlineProvider = userOnlineProvider;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setUserService(UserServiceImpl userService) {
        this.userService = userService;
    }

    @Override
    public CaptchaProvider<CaptchaResult> getCaptchaProvider() {
        return this.captchaProvider;
    }

    @Override
    public void setCaptchaProvider(CaptchaProvider<CaptchaResult> captchaProvider) {
        this.captchaProvider = captchaProvider;
    }
}

