/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.callback;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.PlatformUserCallback;
import com.iplatform.base.SystemController;
import com.iplatform.base.callback.AfterLoginCallback;
import com.iplatform.base.callback.SecurityCallback;
import com.iplatform.base.callback.UserProfileCallback;
import com.walker.infrastructure.ApplicationCallback;
import com.walker.infrastructure.ApplicationRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class PlatformCallbackPostProcessor
implements BeanPostProcessor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<Class<?>, Object> callbackReference = new HashMap(4);
    private static final Map<String, Object> multipleCallbackBeans = new HashMap<String, Object>(8);
    private List<Class<?>> callbackList = Arrays.asList(PlatformUserCallback.class, PlatformLoginCallback.class, UserProfileCallback.class, AfterLoginCallback.class, SecurityCallback.class);
    private List<SystemController> systemControllerList = new ArrayList<SystemController>(64);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ApplicationCallback.class.isAssignableFrom(bean.getClass())) {
            String beanClazzName = bean.getClass().getName();
            Object existBean = null;
            for (Class<?> callbackClazz : this.callbackList) {
                if (!callbackClazz.isAssignableFrom(bean.getClass())) continue;
                if (((ApplicationCallback)bean).supportMultiple()) {
                    multipleCallbackBeans.put(beanClazzName, bean);
                } else {
                    existBean = callbackReference.get(callbackClazz);
                    if (existBean != null) {
                        throw new ApplicationRuntimeException("...... \u56de\u8c03\u5b9e\u73b0\u7c7b\u5df2\u7ecf\u52a0\u8f7d\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e: " + existBean.getClass().getName());
                    }
                    callbackReference.put(callbackClazz, bean);
                }
                this.logger.info("\u52a0\u8f7d\u4e86'CallbackBean'=" + beanClazzName);
            }
        } else if (SystemController.class.isAssignableFrom(bean.getClass())) {
            this.systemControllerList.add((SystemController)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public static final <T> T getCallbackObject(Class<T> callbackClass) {
        if (callbackClass == null) {
            return null;
        }
        Object bean = callbackReference.get(callbackClass);
        if (bean != null) {
            return (T)bean;
        }
        return null;
    }

    public static final <T> T getCallbackMultipleBean(Class<T> callbackBean) {
        if (callbackBean == null) {
            return null;
        }
        Object bean = multipleCallbackBeans.get(callbackBean.getName());
        if (bean != null) {
            return (T)bean;
        }
        return null;
    }

    public List<SystemController> getSystemControllerList() {
        return this.systemControllerList;
    }
}

