/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.captcha;

import com.iplatform.base.util.CaptchaUtils;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public abstract class AbstractCaptchaProvider
implements CaptchaProvider<CaptchaResult> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ResourceLoader resourceLoader = new DefaultResourceLoader();
    protected final Random bgRandom = new Random();
    protected final Random blockRandom = new Random();
    protected static final String IMAGE_TYPE_PNG = "png";
    protected static final String IMAGE_TYPE_JPG = "jpg";
    protected static int captchaInterferenceOptions = 0;
    protected static final int SLIP_OFFSET = 6;
    protected static String waterMark = "\u6211\u7684\u6c34\u5370";
    protected static String waterMarkFontStr = "WenQuanZhengHei.ttf";
    protected Font waterMarkFont;
    protected CacheProvider<String> captchaCacheProvider;

    public boolean validateCaptcha(CaptchaResult data) {
        int xGenerate;
        String verifyKey = CaptchaUtils.getVerifyKey(data);
        String xSource = (String)this.captchaCacheProvider.getCacheData(verifyKey);
        if (StringUtils.isEmpty((String)xSource)) {
            this.logger.error("\u62fc\u56fe\u9a8c\u8bc1\u4fe1\u606f\u5df2\u5931\u6548!");
            return false;
        }
        int xValidate = Double.valueOf(data.getCode()).intValue();
        return xValidate - (xGenerate = Integer.parseInt(xSource)) <= 6 && xValidate - xGenerate >= -6;
    }

    BufferedImage loadBufferedImage(String imageName) throws Exception {
        if (StringUtils.isEmpty((String)imageName)) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u56fe\u7247\u540d\u79f0\u53c2\u6570\u7f3a\u5931\uff1aimageName");
        }
        return ImageIO.read(this.resourceLoader.getResource(imageName).getInputStream());
    }

    public void setCaptchaCacheProvider(CacheProvider<String> captchaCacheProvider) {
        this.captchaCacheProvider = captchaCacheProvider;
    }
}

