/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.captcha;

import com.iplatform.base.push.DefaultPushManager;
import com.iplatform.base.util.CaptchaUtils;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.core.BeanContextAware;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsCaptchaProvider
implements CaptchaProvider<CaptchaResult> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PushManager pushManager;

    public CaptchaResult generateCaptcha(Object param) {
        if (param == null) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u5fc5\u987b\u63d0\u4f9b");
        }
        String mobile = param.toString();
        if (StringUtils.isEmpty((String)mobile)) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u9a8c\u8bc1\u77ed\u4fe1");
        }
        String code = StringUtils.generateRandomNumber((int)4);
        if (this.pushManager instanceof DefaultPushManager) {
            ((DefaultPushManager)this.pushManager).pushSmsValidateCode(code, mobile, "creator");
        } else {
            Notification notification = NotificationUtils.acquireSmsValidateCode("templateId", code, mobile, "creator");
            notification.setPersistent(false);
            this.pushManager.pushSms(notification);
        }
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setCode(code);
        captchaResult.setImage(null);
        return captchaResult;
    }

    public boolean validateCaptcha(CaptchaResult data) {
        CacheProvider captchaCacheProvider = (CacheProvider)BeanContextAware.getBeanByName((String)"captchaCacheProvider");
        String smsCodeGenerate = (String)captchaCacheProvider.getCacheData(CaptchaUtils.getVerifyKey(data));
        if (StringUtils.isEmpty((String)smsCodeGenerate)) {
            this.logger.error("SmsCaptchaProvider\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u4fe1\u606f\u5df2\u5931\u6548!");
            return false;
        }
        if (smsCodeGenerate.equals(data.getCode())) {
            this.logger.debug("app\u9a8c\u8bc1\u5bc6\u7801\u6210\u529f\uff0csmsCode={}, input={}", (Object)smsCodeGenerate, (Object)data.getCode());
            return true;
        }
        return false;
    }

    public CaptchaType getCaptchaType() {
        return CaptchaType.SmsCode;
    }

    public void setPushManager(PushManager pushManager) {
        this.pushManager = pushManager;
    }
}

