/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.captcha.BlockPuzzleCaptchaProvider;
import com.iplatform.base.captcha.JigsawCaptchaProvider;
import com.iplatform.base.captcha.SmsCaptchaProvider;
import com.iplatform.base.config.CaptchaProperties;
import com.iplatform.core.PlatformConfiguration;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import java.lang.reflect.Constructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CaptchaConfig
extends PlatformConfiguration {
    @Bean
    public CaptchaProperties captchaProperties() {
        return new CaptchaProperties();
    }

    @Bean
    public BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider(CacheProvider<String> captchaCacheProvider) {
        BlockPuzzleCaptchaProvider captchaProvider = new BlockPuzzleCaptchaProvider();
        captchaProvider.setCaptchaCacheProvider(captchaCacheProvider);
        return captchaProvider;
    }

    @Deprecated
    @Bean
    public JigsawCaptchaProvider jigsawCaptchaProvider(CacheProvider<String> captchaCacheProvider) {
        JigsawCaptchaProvider jigsawCaptchaProvider = new JigsawCaptchaProvider();
        jigsawCaptchaProvider.setCaptchaCacheProvider(captchaCacheProvider);
        return jigsawCaptchaProvider;
    }

    @Bean(value={"smsCaptchaProvider"})
    public SmsCaptchaProvider smsCaptchaProvider(PushManager pushManager) {
        SmsCaptchaProvider smsCaptchaProvider = new SmsCaptchaProvider();
        smsCaptchaProvider.setPushManager(pushManager);
        return smsCaptchaProvider;
    }

    @Bean(value={"imageCaptchaProvider"})
    public CaptchaProvider<CaptchaResult> imageCaptchaProvider(CaptchaProperties captchaProperties) {
        String imageCaptchaClass = captchaProperties.getImageCaptchaClass();
        if (StringUtils.isEmpty((String)imageCaptchaClass)) {
            throw new IllegalArgumentException("\u56fe\u50cf\u9a8c\u8bc1\u7801\u63d0\u4f9b\u8005\u7c7b\u672a\u914d\u7f6e: CaptchaProperties --> imageCaptchaClass");
        }
        try {
            this.logger.info("\u521b\u5efa'\u56fe\u50cf\u9a8c\u8bc1\u7801\u63d0\u4f9b\u8005' = " + imageCaptchaClass);
            Class captchaProviderClass = ClassUtils.forName((String)imageCaptchaClass, (ClassLoader)CaptchaConfig.class.getClassLoader());
            Constructor constructor = captchaProviderClass.getConstructor(new Class[0]);
            return (CaptchaProvider)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa'\u56fe\u50cf\u9a8c\u8bc1\u7801'\u63d0\u4f9b\u8005\u5b9e\u4f8b\u5f02\u5e38:" + e.getMessage(), e);
        }
    }
}

