/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.cache.LocalCaptchaCacheProvider;
import com.iplatform.base.cache.LocalCategoryCacheProvider;
import com.iplatform.base.cache.LocalDeptCacheProvider;
import com.iplatform.base.cache.LocalHostCacheProvider;
import com.iplatform.base.cache.LocalNotificationTemplateCache;
import com.iplatform.base.cache.LocalPushCacheProvider;
import com.iplatform.base.cache.LocalSystemGroupCache;
import com.iplatform.base.cache.LocalUserCacheProvider;
import com.iplatform.base.cache.LocalUserLoginCache;
import com.iplatform.base.cache.LocalUserOnlineProvider;
import com.iplatform.base.config.CacheConfiguration;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.support.DatabaseArgumentsManager;
import com.iplatform.model.po.S_host;
import com.walker.cache.CacheProvider;
import com.walker.jdbc.service.PubService;
import com.walker.web.UserOnlineProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iplatform.cache", name={"redis-enabled"}, havingValue="false", matchIfMissing=true)
public class LocalCacheConfig
extends CacheConfiguration {
    @Bean
    public NotificationTemplateCache notificationTemplateCache(NotificationServiceImpl notificationService) {
        LocalNotificationTemplateCache cache = new LocalNotificationTemplateCache();
        cache.setNotificationService(notificationService);
        return cache;
    }

    @Bean
    public UserLoginCache userLoginCache() {
        LocalUserLoginCache cache = new LocalUserLoginCache();
        return cache;
    }

    @Bean
    public SystemGroupCache systemGroupCache(GroupServiceImpl groupService) {
        LocalSystemGroupCache cache = new LocalSystemGroupCache();
        cache.setGroupService(groupService);
        return cache;
    }

    @Bean
    public CategoryCacheProvider localCategoryCacheProvider(CategoryServiceImpl categoryService) {
        LocalCategoryCacheProvider categoryCacheProvider = new LocalCategoryCacheProvider();
        categoryCacheProvider.setCategoryService(categoryService);
        return categoryCacheProvider;
    }

    @Bean
    public PushCacheProvider pushCacheProvider() {
        return new LocalPushCacheProvider();
    }

    @Bean
    public UserOnlineProvider userOnlineProvider() {
        return new LocalUserOnlineProvider();
    }

    @Bean(value={"captchaCacheProvider"})
    public CacheProvider<String> cacheProviderCaptchaLocal() {
        return new LocalCaptchaCacheProvider();
    }

    @Bean
    public LocalDeptCacheProvider localDeptCacheProvider(DeptServiceImpl deptService) {
        LocalDeptCacheProvider localDeptCacheProvider = new LocalDeptCacheProvider();
        localDeptCacheProvider.setDeptService(deptService);
        return localDeptCacheProvider;
    }

    @Bean
    public DatabaseArgumentsManager databaseArgumentsManager(ConfigArgumentServiceImpl configArgumentService) {
        DatabaseArgumentsManager databaseArgumentsManager = new DatabaseArgumentsManager();
        databaseArgumentsManager.setConfigArgumentService(configArgumentService);
        return databaseArgumentsManager;
    }

    @Bean
    public UserCacheProvider userCacheProviderForLocal(UserServiceImpl userService) {
        LocalUserCacheProvider localUserCacheProvider = new LocalUserCacheProvider();
        localUserCacheProvider.setUserService(userService);
        return localUserCacheProvider;
    }

    @Bean
    public CacheProvider<S_host> cacheProviderHostLocal(PubService pubService) throws Exception {
        LocalHostCacheProvider localHostCacheProvider = new LocalHostCacheProvider();
        localHostCacheProvider.setPubService(pubService);
        this.logger.info("\u521d\u59cb\u5316\u7f13\u5b58: HostLocalCacheProvider");
        return localHostCacheProvider;
    }
}

