/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.config.PushProperties;
import com.iplatform.base.push.DefaultPushListener;
import com.iplatform.base.push.DefaultPushManager;
import com.iplatform.base.push.MockSmsPush;
import com.iplatform.base.push.SystemPush;
import com.iplatform.base.service.PushServiceImpl;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.core.PlatformConfiguration;
import com.walker.push.PushManager;
import com.walker.push.PushStatusListener;
import com.walker.push.Pushable;
import java.util.ArrayList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class PushConfig
extends PlatformConfiguration {
    @Bean
    public PushProperties pushProperties() {
        return new PushProperties();
    }

    @Bean
    public PushManager pushManager(ThreadPoolTaskExecutor threadPoolTaskExecutor, PushProperties pushProperties, PushStatusListener pushStatusListener) {
        DefaultPushManager pushManager = new DefaultPushManager();
        pushManager.setSmsId(pushProperties.getSmsPushName());
        pushManager.setSmsTemplateCode(pushProperties.getSmsTemplateCode());
        Object[] data = NotificationUtils.acquireMessagePushRules(pushProperties.getMessageType());
        pushManager.setMessageParallel((Boolean)data[0]);
        String[] indexList = (String[])data[1];
        if (indexList == null || indexList.length == 0) {
            throw new IllegalStateException("\u63a8\u9001\uff08\u666e\u901a\u6d88\u606f\uff09\u914d\u7f6e\u89c4\u5219\u4e0d\u5b58\u5728!");
        }
        ArrayList<String> channelNameList = new ArrayList<String>(4);
        for (String index : indexList) {
            channelNameList.add(index);
        }
        pushManager.setMessageChannelNames(channelNameList);
        pushManager.setThreadPoolTaskExecutor(threadPoolTaskExecutor);
        pushManager.setAsyncListener(pushStatusListener);
        pushManager.setMailFrom(pushProperties.getMailFrom());
        return pushManager;
    }

    @Bean
    public PushStatusListener pushStatusListener(PushCacheProvider pushCacheProvider, PushServiceImpl pushService) {
        DefaultPushListener pushListener = new DefaultPushListener();
        pushListener.setPushService(pushService);
        pushListener.setPushCacheProvider(pushCacheProvider);
        return pushListener;
    }

    @Bean
    public MockSmsPush mockSmsPush(PushManager pushManager) {
        MockSmsPush mockSmsPush = new MockSmsPush();
        mockSmsPush.startup();
        pushManager.register((Pushable)mockSmsPush);
        return mockSmsPush;
    }

    @Bean
    public SystemPush systemPush(PushManager pushManager) {
        SystemPush systemPush = new SystemPush();
        systemPush.startup();
        pushManager.register((Pushable)systemPush);
        return systemPush;
    }
}

