/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.config;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.WechatCacheProvider;
import com.iplatform.base.cache.RedisCaptchaCacheProvider;
import com.iplatform.base.cache.RedisCategoryCacheProvider;
import com.iplatform.base.cache.RedisDeptCacheProvider;
import com.iplatform.base.cache.RedisHostCacheProvider;
import com.iplatform.base.cache.RedisNotificationTemplateCache;
import com.iplatform.base.cache.RedisPushCacheProvider;
import com.iplatform.base.cache.RedisSystemGroupCache;
import com.iplatform.base.cache.RedisUserCacheProvider;
import com.iplatform.base.cache.RedisUserLoginCache;
import com.iplatform.base.cache.RedisUserOnlineProvider;
import com.iplatform.base.cache.RedisWechatCache;
import com.iplatform.base.config.CacheConfiguration;
import com.iplatform.base.config.CacheProperties;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.support.RedisArgumentsManager;
import com.iplatform.model.po.S_host;
import com.walker.cache.CacheProvider;
import com.walker.jdbc.service.PubService;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCacheProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnProperty(prefix="iplatform.cache", name={"redis-enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnClass(value={RedisCacheProvider.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisCacheConfig
extends CacheConfiguration {
    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)stringRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)stringRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedisHelper redisHelper(RedisTemplate<String, Object> redisTemplate) {
        RedisHelper redisHelper = new RedisHelper(redisTemplate);
        return redisHelper;
    }

    @Bean
    public CacheProvider<S_host> cacheProviderHostRedis(PubService pubService, RedisHelper redisHelper) throws Exception {
        RedisHostCacheProvider redisHostCacheProvider = new RedisHostCacheProvider();
        redisHostCacheProvider.setRedisHelper(redisHelper);
        redisHostCacheProvider.setPubService(pubService);
        this.logger.info("\u521d\u59cb\u5316\u7f13\u5b58: HostRedisCacheProvider");
        return redisHostCacheProvider;
    }

    @Bean
    public UserCacheProvider userCacheProviderForRedis(UserServiceImpl userService, RedisHelper redisHelper, CacheProperties cacheProperties) {
        RedisUserCacheProvider redisUserCacheProvider = new RedisUserCacheProvider();
        redisUserCacheProvider.setUserService(userService);
        redisUserCacheProvider.setRedisHelper(redisHelper);
        redisUserCacheProvider.setAllowInitCache(!cacheProperties.isOrgUserBig());
        return redisUserCacheProvider;
    }

    @Bean(value={"captchaCacheProvider"})
    public CacheProvider<String> cacheProviderCaptchaRedis(RedisHelper redisHelper) {
        RedisCaptchaCacheProvider redisCaptchaCacheProvider = new RedisCaptchaCacheProvider();
        redisCaptchaCacheProvider.setRedisHelper(redisHelper);
        return redisCaptchaCacheProvider;
    }

    @Bean
    public RedisUserOnlineProvider redisUserOnlineProvider(RedisHelper redisHelper) {
        RedisUserOnlineProvider userOnlineProvider = new RedisUserOnlineProvider();
        userOnlineProvider.setRedisHelper(redisHelper);
        return userOnlineProvider;
    }

    @Bean
    public RedisArgumentsManager redisArgumentsManager(ConfigArgumentServiceImpl configArgumentService, RedisHelper redisHelper) {
        RedisArgumentsManager redisArgumentsManager = new RedisArgumentsManager();
        redisArgumentsManager.setConfigArgumentService(configArgumentService);
        redisArgumentsManager.setRedisHelper(redisHelper);
        return redisArgumentsManager;
    }

    @Bean
    public RedisDeptCacheProvider redisDeptCacheProvider(DeptServiceImpl deptService, RedisHelper redisHelper, CacheProperties cacheProperties) {
        RedisDeptCacheProvider redisDeptCacheProvider = new RedisDeptCacheProvider();
        redisDeptCacheProvider.setDeptService(deptService);
        redisDeptCacheProvider.setRedisHelper(redisHelper);
        redisDeptCacheProvider.setAllowCacheChildren(!cacheProperties.isOrgUserBig());
        return redisDeptCacheProvider;
    }

    @Bean
    public PushCacheProvider pushCacheProvider(RedisHelper redisHelper) {
        RedisPushCacheProvider pushCacheProvider = new RedisPushCacheProvider();
        pushCacheProvider.setRedisHelper(redisHelper);
        return pushCacheProvider;
    }

    @Bean
    public CategoryCacheProvider categoryCacheProvider(RedisHelper redisHelper, CategoryServiceImpl categoryService) {
        RedisCategoryCacheProvider categoryCacheProvider = new RedisCategoryCacheProvider();
        categoryCacheProvider.setRedisHelper(redisHelper);
        categoryCacheProvider.setCategoryService(categoryService);
        return categoryCacheProvider;
    }

    @Bean
    public SystemGroupCache systemGroupCache(RedisHelper redisHelper, GroupServiceImpl groupService) {
        RedisSystemGroupCache cache = new RedisSystemGroupCache();
        cache.setRedisHelper(redisHelper);
        cache.setGroupService(groupService);
        return cache;
    }

    @Bean
    public UserLoginCache userLoginCache(RedisHelper redisHelper) {
        RedisUserLoginCache cache = new RedisUserLoginCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }

    @Bean
    public WechatCacheProvider wechatCacheProvider(RedisHelper redisHelper) {
        RedisWechatCache cache = new RedisWechatCache();
        cache.setRedisHelper(redisHelper);
        return cache;
    }

    @Bean
    public NotificationTemplateCache notificationTemplateCache(RedisHelper redisHelper, NotificationServiceImpl notificationService) {
        RedisNotificationTemplateCache cache = new RedisNotificationTemplateCache();
        cache.setRedisHelper(redisHelper);
        cache.setNotificationService(notificationService);
        return cache;
    }
}

