/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.captcha.BlockPuzzleCaptchaProvider;
import com.iplatform.base.captcha.JigsawCaptchaProvider;
import com.iplatform.base.captcha.JigsawResult;
import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.ResponseValue;
import com.walker.web.util.IdUtils;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaptchaController
extends SystemController {
    private CaptchaProvider<CaptchaResult> imageCaptchaProvider;
    private JigsawCaptchaProvider jigsawCaptchaProvider;
    private BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider;
    private String defaultCaptchaType = "math";

    @Autowired
    public CaptchaController(CaptchaProvider<CaptchaResult> imageCaptchaProvider, JigsawCaptchaProvider jigsawCaptchaProvider, BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider) {
        this.imageCaptchaProvider = imageCaptchaProvider;
        this.jigsawCaptchaProvider = jigsawCaptchaProvider;
        this.blockPuzzleCaptchaProvider = blockPuzzleCaptchaProvider;
    }

    @RequestMapping(value={"/captcha/jigsaw/mobile"})
    public ResponseValue generateJigsawMobileCaptcha() {
        String uuid = IdUtils.simpleUUID();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("uuid", uuid);
        String verifyKey = "captcha_codes:" + uuid;
        JigsawResult captchaResult = (JigsawResult)this.blockPuzzleCaptchaProvider.generateCaptcha(null);
        if (captchaResult == null || captchaResult.getX() == 0) {
            return ResponseValue.error((String)"\u62fc\u56fe\u9a8c\u8bc1\u7801\u751f\u6210\u9519\u8bef, null");
        }
        this.getCaptchaCacheProvider().putCacheData(verifyKey, (Object)String.valueOf(captchaResult.getX()), 60L);
        this.logger.debug("\u5199\u5165\u62fc\u56fe\u9a8c\u8bc1\u4f4d\u7f6e\uff0cx = {}", (Object)captchaResult.getX());
        data.put("y", captchaResult.getY());
        data.put("slider", captchaResult.getImageBlockBase64());
        data.put("bg", captchaResult.getImageSourceBase64());
        return ResponseValue.success(data);
    }

    @PostMapping(value={"/captcha/jigsaw_validate"})
    public ResponseValue validateJigsaw(String token, String x) {
        if (StringUtils.isEmpty((String)token) || StringUtils.isEmpty((String)x)) {
            return ResponseValue.error((String)"\u672a\u63a5\u6536\u5230\u9a8c\u8bc1\u8f93\u5165\u4fe1\u606f!");
        }
        CaptchaResult captchaResult = new CaptchaResult();
        captchaResult.setUuid(token);
        captchaResult.setCode(x);
        HashMap<String, String> data = new HashMap<String, String>(4);
        boolean success = this.jigsawCaptchaProvider.validateCaptcha(captchaResult);
        if (!success) {
            data.put("verify", "-1");
            return ResponseValue.success(data);
        }
        data.put("verify", "1");
        data.put("x", x);
        data.put("uuid", token);
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/captcha/jigsaw"})
    public ResponseValue generateJigsawCaptcha() {
        boolean captchaEnabled = this.getArgumentVariable("security.captcha.enabled").getBooleanValue();
        String uuid = IdUtils.simpleUUID();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("uuid", uuid);
        if (captchaEnabled) {
            String verifyKey = "captcha_codes:" + uuid;
            JigsawResult captchaResult = (JigsawResult)this.jigsawCaptchaProvider.generateCaptcha(null);
            if (captchaResult == null || captchaResult.getX() == 0) {
                return ResponseValue.error((String)"\u62fc\u56fe\u9a8c\u8bc1\u7801\u751f\u6210\u9519\u8bef, null");
            }
            this.getCaptchaCacheProvider().putCacheData(verifyKey, (Object)String.valueOf(captchaResult.getX()), 60L);
            this.logger.debug("\u5199\u5165\u62fc\u56fe\u9a8c\u8bc1\u4f4d\u7f6e\uff0cx = {}", (Object)captchaResult.getX());
            data.put("y", captchaResult.getY());
            data.put("slider", captchaResult.getImageBlockBase64());
            data.put("bg", captchaResult.getImageSourceBase64());
            data.put("captchaEnabled", true);
            return ResponseValue.success(data);
        }
        data.put("captchaEnabled", false);
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/captcha/sms"})
    public ResponseValue generateSmsCaptcha(String phoneNumber) {
        if (StringUtils.isEmpty((String)phoneNumber)) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
        }
        try {
            Map<String, Object> data = this.sendSmsCodeValidation(phoneNumber);
            return ResponseValue.success(data);
        }
        catch (Exception ex) {
            return ResponseValue.error((String)ex.getMessage());
        }
    }

    @GetMapping(value={"/captcha/image"})
    public ResponseValue generateImageCaptcha() {
        boolean captchaEnabled = this.getArgumentVariable("security.captcha.enabled").getBooleanValue();
        String uuid = IdUtils.simpleUUID();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("uuid", uuid);
        if (captchaEnabled) {
            String verifyKey = "captcha_codes:" + uuid;
            CaptchaResult captchaResult = (CaptchaResult)this.imageCaptchaProvider.generateCaptcha((Object)this.defaultCaptchaType);
            if (captchaResult == null) {
                return ResponseValue.error((String)"\u9a8c\u8bc1\u7801\u751f\u6210\u9519\u8bef, null");
            }
            this.getCaptchaCacheProvider().putCacheData(verifyKey, (Object)captchaResult.getCode(), 120L);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u751f\u6210\u56fe\u50cf\u9a8c\u8bc1\u7801:{}, uuid:{}", (Object)captchaResult.getCode(), (Object)uuid);
            }
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)captchaResult.getImage(), "jpg", (OutputStream)os);
                data.put("img", new String(Base64.encode((byte[])os.toByteArray()), "UTF-8"));
                data.put("captchaEnabled", true);
                return ResponseValue.success(data);
            }
            catch (IOException e) {
                return ResponseValue.error((String)e.getMessage());
            }
        }
        data.put("captchaEnabled", false);
        return ResponseValue.success(data);
    }

    @GetMapping(value={"/captcha/none"})
    public ResponseValue generateCaptchaNone() {
        String uuid = IdUtils.simpleUUID();
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("uuid", uuid);
        return ResponseValue.success(data);
    }
}

