/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.di;

import com.iplatform.base.di.DataImportEngine;
import com.iplatform.base.di.JdbcExcelDataImportor;
import com.iplatform.base.di.TemplateInfo;
import com.walker.di.DataImportException;
import com.walker.di.TemplateException;
import com.walker.di.TemplateGenerator;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataImportEngine<T>
implements DataImportEngine<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private TemplateGenerator<T> templateGenerator;
    private String saveFileRootInfo = null;

    @Override
    public void setTemplateGenerator(TemplateGenerator<T> templateGenerator) {
        if (templateGenerator == null) {
            throw new IllegalArgumentException("templateGenerator \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.templateGenerator = templateGenerator;
    }

    @Override
    public T generateTemplate(TemplateInfo templateInfo) {
        try {
            return (T)this.templateGenerator.generate((Object)templateInfo);
        }
        catch (TemplateException e) {
            this.logger.error("\u751f\u6210\u5bfc\u5165\u6a21\u677f\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String executeImport(JdbcExcelDataImportor dataImportor, String loginId) throws DataImportException {
        if (dataImportor == null) {
            throw new DataImportException("\u672a\u4f20\u5165\u5bfc\u5165\u5668\u5bf9\u8c61: JdbcExcelDataImportor", null);
        }
        String id = dataImportor.getId();
        if (StringUtils.isNotEmpty((String)id)) {
            this.logger.debug("\u4fdd\u5b58\u6216\u8005\u66f4\u65b0\u5bfc\u5165\u5386\u53f2\u8bb0\u5f55,id=" + id);
            try {
                this.saveImportHistory(id, loginId);
            }
            catch (Exception ex) {
                throw new DataImportException("\u4fdd\u5b58\u5bfc\u5165\u5386\u53f2\u9519\u8bef:" + ex.getMessage() + ", id=" + id, (Throwable)ex);
            }
        } else {
            this.logger.info("\u5f53\u524d\u5bfc\u5165\u672a\u8bbe\u7f6eid\uff0c\u4e0d\u8bb0\u5f55\u5bfc\u5165\u5386\u53f2, loginId = " + loginId);
        }
        dataImportor.setSaveFileFolder(this.saveFileRootInfo);
        dataImportor.load();
        this.logger.info("\u5bfc\u5165\u6210\u529f\u5199\u5165{}\u6761\u8bb0\u5f55", (Object)dataImportor.getSuccessSize());
        return dataImportor.getErrorFile();
    }

    @Override
    public void setSaveFileRoot(String saveFileRootInfo) {
        this.saveFileRootInfo = saveFileRootInfo;
    }

    protected abstract void saveImportHistory(String var1, String var2);
}

