/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.di;

import com.iplatform.base.service.DataImportServiceImpl;
import com.iplatform.base.util.DataImportUtils;
import com.iplatform.core.BeanContextAware;
import com.walker.di.BusinessImportException;
import com.walker.di.UpdateResult;
import com.walker.di.UpdateType;
import com.walker.di.excel.ExcelDataImportor;
import com.walker.infrastructure.utils.StringUtils;
import java.util.List;
import java.util.Map;

public abstract class JdbcExcelDataImportor
extends ExcelDataImportor {
    private String updateSql = null;

    protected void saveImportData(List<Object[]> dataList, List<String> fieldNames) throws BusinessImportException {
        if (!this.isCheckDataExist()) {
            this.logger.debug("\u4e0d\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728\uff0c\u76f4\u63a5\u5bfc\u5165, size = " + dataList.size());
            try {
                this.doExecuteInsert(dataList, fieldNames);
            }
            catch (Exception ex) {
                throw new BusinessImportException("\u4fdd\u5b58\u4e00\u6b21\u5bfc\u5165\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        String tableName = this.acquireTableName();
        this.logger.debug("\u51c6\u5907\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728");
        List<Map<String, Object>> mapList = DataImportUtils.translateToMap(dataList, fieldNames);
        if (mapList == null) {
            this.logger.error("\u4fdd\u5b58\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58: mapList = DataImportUtils.translateTo() == null!");
            return;
        }
        UpdateResult updateResult = this.checkDataExist(tableName, mapList);
        if (updateResult == null) {
            throw new BusinessImportException("\u4e1a\u52a1\u68c0\u67e5\u5bfc\u5165\u662f\u5426\u5b58\u5728\u6570\u636e, \u4f46\u672a\u8fd4\u56de\u4efb\u4f55\u5185\u5bb9, \u7cfb\u7edf\u65e0\u6cd5\u66f4\u65b0,table=" + tableName, null);
        }
        if (!StringUtils.isEmptyList((List)updateResult.getInsertList())) {
            this.doExecuteInsertMap(updateResult.getInsertList(), fieldNames);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("........ doExecuteInsert():" + updateResult.getInsertList().size());
            }
        }
        if (!StringUtils.isEmptyList((List)updateResult.getUpdateList())) {
            if (StringUtils.isEmptyList((List)updateResult.getUpdateColumnNames()) || StringUtils.isEmptyList((List)updateResult.getWhereColumnNames())) {
                throw new BusinessImportException("\u5bfc\u5165\u66f4\u65b0\u6570\u636e\uff0c\u4f46\u672a\u53d1\u73b0\u4efb\u4f55\u66f4\u65b0\u5b57\u6bb5\u540d\u79f0\u548c\u6761\u4ef6,table=" + tableName, null);
            }
            this.doExecuteUpdateMap(updateResult.getUpdateList(), updateResult.getUpdateColumnNames(), updateResult.getWhereColumnNames(), tableName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("........ doExecuteUpdate():" + updateResult.getUpdateList().size());
            }
        }
    }

    protected void saveBrokenInfo(long index) {
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u65ad\u70b9\u7eed\u4f20\u529f\u80fd");
    }

    private void doExecuteInsertMap(List<Map<String, Object>> mapList, List<String> fieldNames) {
        String insertSql = this.getInsertSql(fieldNames);
        List<Object[]> dataList = DataImportUtils.translateToArray(mapList, fieldNames);
        if (StringUtils.isEmptyList(dataList)) {
            this.logger.debug("\u65e0\u6cd5\u6267\u884cdoExecuteInsertMap: DataImportUtils.translateToArray = null.");
            return;
        }
        this.getDataImportService().execBatchUpdate(insertSql, dataList);
    }

    private void doExecuteUpdateMap(List<Map<String, Object>> dataList, List<String> updateColumns, List<String> whereColumns, String tableName) {
        if (this.getUpdateType() == UpdateType.Override) {
            this.logger.debug("\u8bbe\u7f6e\u7684\u66f4\u65b0\u7b56\u7565: Override");
            if (StringUtils.isEmptyList(updateColumns) || StringUtils.isEmptyList(whereColumns)) {
                throw new IllegalArgumentException("\u5bfc\u5165'\u65e0\u6cd5\u66f4\u65b0\u6570\u636e': updateColumns or whereColumns \u4e3a\u7a7a!");
            }
            List<Object[]> parameters = DataImportUtils.acquireUpdateValues(dataList, updateColumns, whereColumns);
            if (StringUtils.isEmptyList(parameters)) {
                this.logger.debug("\u672a\u627e\u5230\u66f4\u65b0\u503c\u96c6\u5408,\u4e0d\u66f4\u65b0\u8bb0\u5f55");
                return;
            }
            if (this.updateSql == null) {
                this.updateSql = DataImportUtils.acquireUpdateSql(tableName, updateColumns, whereColumns);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u66f4\u65b0SQL = " + this.updateSql);
                }
            }
            this.getDataImportService().execBatchUpdate(this.updateSql, parameters);
        }
    }

    protected void doExecuteInsert(List<Object[]> dataList, List<String> fieldNames) {
        this.getDataImportService().execBatchUpdate(this.getInsertSql(fieldNames), dataList);
    }

    private String getInsertSql(List<String> fieldNames) {
        String tableName = this.acquireTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            throw new UnsupportedOperationException("\u5fc5\u987b\u5b9e\u73b0\u65b9\u6cd5: acquireTableName");
        }
        return DataImportUtils.acquireInsertSql(tableName, fieldNames);
    }

    public DataImportServiceImpl getDataImportService() {
        return (DataImportServiceImpl)((Object)BeanContextAware.getBeanByType(DataImportServiceImpl.class));
    }

    protected abstract String acquireTableName();

    protected abstract boolean isCheckDataExist();

    protected abstract UpdateResult checkDataExist(String var1, List<Map<String, Object>> var2);
}

