/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.push;

import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.service.PushServiceImpl;
import com.iplatform.model.po.S_message;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushStatusListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPushListener
implements PushStatusListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_VALUE = ";";
    private PushCacheProvider pushCacheProvider = null;
    private PushServiceImpl pushService = null;

    public void onSuccess(Notification notification, Object option, NotificationChannel channel) {
        if (notification.getPersistent()) {
            this.logger.info("\u4e1a\u52a1\u4fdd\u5b58'\u6210\u529f\u901a\u77e5'\uff1achannel = {}, data={}", (Object)channel, (Object)notification);
            if (!this.isBusinessNotification(notification)) {
                this.invokeDatabase(notification, true, channel);
                return;
            }
            if (!notification.getParallel()) {
                this.invokeDatabase(notification, true, channel);
                return;
            }
            String cacheKey = this.getKey(notification.getReceiverList(), notification.getOptionType(), notification.getOptionId());
            if (this.isInCache(cacheKey)) {
                this.logger.debug("\u7f13\u5b58\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf4\u660e\u901a\u77e5\u5df2\u7ecf\u4fdd\u5b58\u8fc7\uff0cbizId={}", (Object)notification.getOptionId());
                return;
            }
            this.invokeDatabase(notification, true, channel);
            this.putToCache(cacheKey);
        }
    }

    public void onException(Notification notification, String error, NotificationChannel channel) {
        if (notification.getPersistent()) {
            this.logger.info("\u4e1a\u52a1\u4fdd\u5b58'\u5931\u8d25\u901a\u77e5'\uff1achannel = {}, data = {}", (Object)channel, (Object)notification);
            if (!this.isBusinessNotification(notification)) {
                this.invokeDatabase(notification, false, channel);
                return;
            }
            if (!notification.getParallel()) {
                this.invokeDatabase(notification, false, channel);
                return;
            }
            String cacheKey = this.getKey(notification.getReceiverList(), notification.getOptionType(), notification.getOptionId());
            if (this.isInCache(cacheKey)) {
                this.logger.debug("\u7f13\u5b58\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf4\u660e\u901a\u77e5\u5df2\u7ecf\u4fdd\u5b58\u8fc7\uff0cbizId={}", (Object)notification.getOptionId());
                return;
            }
            this.invokeDatabase(notification, false, channel);
            this.putToCache(cacheKey);
        }
    }

    private void invokeDatabase(Notification notification, boolean success, NotificationChannel channel) {
        ArrayList<S_message> data = new ArrayList<S_message>(4);
        for (String userId : notification.getReceiverList()) {
            S_message message = new S_message();
            message.setId(String.valueOf(NumberGenerator.getLongSequenceNumber()));
            message.setCreate_time(Long.valueOf(notification.getCreateTime()));
            message.setCreator(notification.getCreator());
            message.setBroad_cast(Integer.valueOf(notification.getBroadcast() ? 1 : 0));
            message.setTitle(notification.getTitle());
            message.setContent(notification.getContent());
            message.setChannel_index(channel.getIndex());
            message.setDelayed_time(Long.valueOf(notification.getDelayedTime()));
            message.setFailed(Integer.valueOf(success ? 0 : 1));
            message.setMsg_from(notification.getFrom());
            message.setTime_type(Integer.valueOf(notification.getTimeType().getIndex()));
            message.setOption_id(notification.getOptionId());
            message.setRead_done(Integer.valueOf(0));
            message.setReceiver(userId);
            if (StringUtils.isEmpty((String)notification.getOptionType())) {
                message.setOption_type("no_type");
            } else {
                message.setOption_type(notification.getOptionType());
            }
            data.add(message);
        }
        this.pushService.insertBatch(data);
    }

    private void putToCache(String key) {
        this.pushCacheProvider.put(key, CACHE_VALUE);
    }

    private boolean isInCache(String key) {
        String value = this.pushCacheProvider.get(key);
        return value != null;
    }

    private String getKey(List<String> userIds, String optionType, String optionId) {
        StringBuilder sb = new StringBuilder(optionType).append(optionId);
        for (String userId : userIds) {
            sb.append(userId);
        }
        return "notification:" + sb.toString().hashCode();
    }

    private boolean isBusinessNotification(Notification notification) {
        return StringUtils.isNotEmpty((String)notification.getOptionId()) && StringUtils.isNotEmpty((String)notification.getOptionType());
    }

    public void setPushCacheProvider(PushCacheProvider pushCacheProvider) {
        this.pushCacheProvider = pushCacheProvider;
    }

    public void setPushService(PushServiceImpl pushService) {
        this.pushService = pushService;
    }
}

