/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.core.httpapi.ApiInfo;
import com.iplatform.core.httpapi.ApiParam;
import com.walker.jdbc.service.BaseServiceImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ApiInfoServiceImpl
extends BaseServiceImpl {
    private final ApiInfoMapper apiInfoMapper = new ApiInfoMapper();
    private final ApiParamMapper apiParamMapper = new ApiParamMapper();

    public List<ApiInfo> queryApiInfoAll() {
        return this.sqlQuery("select * from s_api_info", new Object[0], this.apiInfoMapper);
    }

    public List<ApiParam> queryApiParamAll() {
        return this.sqlQuery("select * from s_api_param", new Object[0], this.apiParamMapper);
    }

    private class ApiInfoMapper
    implements RowMapper<ApiInfo> {
        private ApiInfoMapper() {
        }

        public ApiInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ApiInfo e = new ApiInfo();
            e.setId(rs.getString("id"));
            e.setCreateTime(rs.getLong("create_time"));
            e.setMethod(rs.getString("method"));
            e.setUrl(rs.getString("url"));
            e.setTitle(rs.getString("title"));
            e.setRequestAsText(rs.getInt("request_as_text"));
            e.setResponseGzip(rs.getInt("response_gzip"));
            if (rs.getObject("request_trans_class") != null) {
                e.setRequestTransClass(rs.getString("request_trans_class"));
            }
            if (rs.getObject("response_type_class") != null) {
                e.setResponseTypeClass(rs.getString("response_type_class"));
            }
            if (rs.getObject("summary") != null) {
                e.setSummary(rs.getString("summary"));
            }
            return e;
        }
    }

    private class ApiParamMapper
    implements RowMapper<ApiParam> {
        private ApiParamMapper() {
        }

        public ApiParam mapRow(ResultSet rs, int rowNum) throws SQLException {
            ApiParam e = new ApiParam();
            e.setId(rs.getString("id"));
            e.setPid(rs.getString("pid"));
            e.setParamType(rs.getInt("param_type"));
            e.setParamKey(rs.getString("param_key"));
            e.setNeedTranslate(rs.getInt("need_translate"));
            if (rs.getObject("param_name") != null) {
                e.setParamName(rs.getString("param_name"));
            }
            if (rs.getObject("param_fix") != null) {
                e.setParamFix(rs.getString("param_fix"));
            }
            return e;
        }
    }
}

