/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_dict_type;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CodeServiceImpl
extends BaseServiceImpl {
    private static final String SQL_PAGE_TYPE_PREFIX = "select * from s_dict_type where 1=1";
    private static final String SQL_PAGE_DATA_PREFIX = "select * from s_dict_data where 1=1";
    private static final String SQL_QUERY_EXIST_DATA = "select * from s_dict_data where dict_type=? and dict_value=?";
    private static final String SQL_DICT_TREE_LIST = "select * from s_dict_data where dict_type=? order by parent_id, dict_sort";

    public void execDeleteDictData(Long[] dictCodes) {
        if (dictCodes == null || dictCodes.length == 0) {
            return;
        }
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(8);
        Long[] longArray = dictCodes;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long dictCode = longArray[i];
            Object[] p = new Object[]{dictCode};
            parameters.add(p);
        }
        this.execBatchUpdate("delete from s_dict_data where dict_code=?", parameters);
    }

    public List queryDictTreeList(String dictType) {
        return this.select(SQL_DICT_TREE_LIST, new Object[]{dictType}, (BasePo)new S_dict_data());
    }

    public List<S_dict_data> queryAllCodeItemList() {
        return this.select("select * from s_dict_data order by dict_sort", new Object[0], (BasePo)new S_dict_data());
    }

    public List<S_dict_type> queryRootCodeList() {
        return this.selectAll((BasePo)new S_dict_type());
    }

    public S_dict_data queryOneDictData(long dictCode) {
        return (S_dict_data)this.get((BasePo)new S_dict_data(Long.valueOf(dictCode)));
    }

    public S_dict_data queryOneDictData(String dictType, String value) {
        return (S_dict_data)this.get(SQL_QUERY_EXIST_DATA, new Object[]{dictType, value}, (BasePo)new S_dict_data());
    }

    public S_dict_type queryOneDictType(long dictId) {
        return (S_dict_type)this.get("select * from s_dict_type where dict_id=?", new Object[]{dictId}, (BasePo)new S_dict_type());
    }

    public GenericPager<S_dict_type> queryPageDictType(String dictName, String dictType, int status, long startTime, long endTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_TYPE_PREFIX);
        if (StringUtils.isNotEmpty((String)dictName)) {
            sql.append(" and dict_name like :dictName");
            parameters.put("dictName", "%" + dictName + "%");
        }
        if (StringUtils.isNotEmpty((String)dictType)) {
            sql.append(" and dict_type = :dictType");
            parameters.put("dictType", dictType);
        }
        if (status >= 0) {
            sql.append(" and status = :status");
            parameters.put("status", status);
        }
        if (startTime > 0L) {
            sql.append(" and create_time >= :startTime");
            parameters.put("startTime", startTime);
        }
        if (endTime > 0L) {
            sql.append(" and create_time <= :endTime");
            parameters.put("endTime", endTime);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_dict_type());
    }

    public GenericPager<S_dict_data> queryPageDictData(String dictType, String dictLabel) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_DATA_PREFIX);
        if (StringUtils.isNotEmpty((String)dictType)) {
            sql.append(" and dict_type = :dictType");
            parameters.put("dictType", dictType);
        }
        if (StringUtils.isNotEmpty((String)dictLabel)) {
            sql.append(" and dict_label like :dictLabel");
            parameters.put("dictLabel", "%" + dictLabel + "%");
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_dict_data());
    }

    public List<S_dict_data> queryDictDataByType(String dictType) {
        return this.select((BasePo)new S_dict_data(), "where status=0 and dict_type=? order by dict_sort asc", new Object[]{dictType});
    }
}

