/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.model.po.S_login_info;
import com.iplatform.model.po.S_oper_log;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends BaseServiceImpl {
    private static final String SQL_PAGE_LOGIN_LOG = "select * from s_login_info where 1=1";
    private static final String SQL_PAGE_OPERATE_LOG = "select * from s_oper_log where 1=1";

    public GenericPager<S_oper_log> queryPageOperateLogList(String operateName, Integer businessType, Integer status, String title) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_OPERATE_LOG);
        if (StringUtils.isNotEmpty((String)operateName)) {
            sql.append(" and oper_name = :operateName");
            parameters.put("operateName", operateName);
        }
        if (businessType != null) {
            sql.append(" and business_type = :businessType");
            parameters.put("businessType", businessType);
        }
        if (status != null && (status == 1 || status == 0)) {
            sql.append(" and status = :status");
            parameters.put("status", status);
        }
        if (StringUtils.isNotEmpty((String)title)) {
            sql.append(" and title = :title");
            parameters.put("title", title);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_oper_log());
    }

    public GenericPager<S_login_info> queryPageLoginLogList(String ip, String userName, String status) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_LOGIN_LOG);
        if (StringUtils.isNotEmpty((String)ip)) {
            sql.append(" and ipaddr = :ipaddr");
            parameters.put("ipaddr", ip);
        }
        if (StringUtils.isNotEmpty((String)userName)) {
            sql.append(" and user_name = :userName");
            parameters.put("userName", userName);
        }
        if (StringUtils.isNotEmpty((String)status)) {
            sql.append(" and status = :status");
            parameters.put("status", status);
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_login_info());
    }

    public void execClearOperateLog() {
        this.execute("truncate table s_oper_log", new Object[0]);
    }

    public void execClearLoginLog() {
        this.execute("truncate table s_login_info", new Object[0]);
    }

    public void execInsertOperateLog(S_oper_log s_oper_log) {
        s_oper_log.setOper_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        s_oper_log.setOper_id(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        this.insert((BasePo)s_oper_log);
    }

    public void execInsertLoginLog(S_login_info s_login_info, Long userId) {
        if (s_login_info != null) {
            this.insert((BasePo)s_login_info);
        }
    }
}

